/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class FlatteningSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private static final long serialVersionUID = -6130180289951110573L;
    private static final Pattern CHECK_IF_FLATTEN_PROPERTY_PATTERN = Pattern.compile(".+[^\\\\]\\..+");
    private static final Pattern UNESCAPED_PERIOD_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private static final Pattern CHECK_IF_ESCAPED_MAP_PATTERN = Pattern.compile(".*[^\\\\]\\\\..+");
    private static final Pattern REPLACE_ESCAPED_MAP_PATTERN = Pattern.compile("\\\\.");
    private static final ClientLogger LOGGER = new ClientLogger(FlatteningSerializer.class);
    private final BeanDescription beanDescription;
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;
    private final boolean classHasJsonFlatten;
    private final Set<String> jsonPropertiesWithJsonFlatten;

    FlatteningSerializer(BeanDescription beanDesc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(beanDesc.getBeanClass(), false);
        this.beanDescription = beanDesc;
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
        this.classHasJsonFlatten = beanDesc.getClassAnnotations().has(JsonFlatten.class);
        this.jsonPropertiesWithJsonFlatten = this.classHasJsonFlatten ? Collections.emptySet() : beanDesc.findProperties().stream().filter(BeanPropertyDefinition::hasField).filter(property -> property.getField().hasAnnotation(JsonFlatten.class)).map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            @Override
            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                boolean hasJsonFlattenOnClass = beanDesc.getClassAnnotations().has(JsonFlatten.class);
                boolean hasJsonFlattenOnProperty = beanDesc.findProperties().stream().filter(BeanPropertyDefinition::hasField).map(BeanPropertyDefinition::getField).anyMatch(field -> field.hasAnnotation(JsonFlatten.class));
                if (hasJsonFlattenOnClass || hasJsonFlattenOnProperty) {
                    return new FlatteningSerializer(beanDesc, serializer, mapper);
                }
                return serializer;
            }
        });
        return module;
    }

    private static List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Field f : clazz.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private static void escapeMapKeys(Object value, ClientLogger logger2) {
        if (value == null) {
            return;
        }
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof OffsetDateTime || value instanceof Duration || value instanceof String || value instanceof ExpandableStringEnum) {
            return;
        }
        if (value instanceof Map) {
            for (String key : new HashSet(((Map)value).keySet())) {
                if (!key.contains(".")) continue;
                String newKey = UNESCAPED_PERIOD_PATTERN.matcher(key).replaceAll("\\\\.");
                Object val2 = ((Map)value).remove(key);
                ((Map)value).put(newKey, val2);
            }
            for (Object val3 : ((Map)value).values()) {
                FlatteningSerializer.escapeMapKeys(val3, logger2);
            }
            return;
        }
        if (value instanceof List) {
            for (Object val4 : (List)value) {
                FlatteningSerializer.escapeMapKeys(val4, logger2);
            }
            return;
        }
        for (Field f : FlatteningSerializer.getAllDeclaredFields(value.getClass())) {
            f.setAccessible(true);
            try {
                FlatteningSerializer.escapeMapKeys(f.get(value), logger2);
            }
            catch (IllegalAccessException e) {
                throw logger2.logExceptionAsError(new RuntimeException(e));
            }
        }
    }

    @Override
    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        if (value == null) {
            gen.writeNull();
            return;
        }
        if (this.classHasJsonFlatten) {
            this.classLevelFlattenSerialize(value, gen);
        } else {
            ObjectNode node = this.mapper.createObjectNode();
            if (typeSer != null) {
                node.put(typeSer.getPropertyName(), typeSer.getTypeIdResolver().idFromValue(value));
            }
            this.propertyOnlyFlattenSerialize(value, gen, provider, node);
        }
    }

    @Override
    public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        this.serializeWithType(value, gen, provider, (TypeSerializer)null);
    }

    @Override
    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)((Object)this.defaultSerializer)).resolve(provider);
        }
    }

    private void propertyOnlyFlattenSerialize(Object value, JsonGenerator gen, SerializerProvider provider, ObjectNode node) throws IOException {
        for (BeanPropertyDefinition beanProp : this.beanDescription.findProperties()) {
            ObjectNode nodeToUse = node;
            String propertyName = beanProp.getName();
            if (this.jsonPropertiesWithJsonFlatten.contains(beanProp.getName())) {
                String[] splitNames = UNESCAPED_PERIOD_PATTERN.split(beanProp.getName());
                propertyName = splitNames[splitNames.length - 1];
                for (int i = 0; i < splitNames.length - 1; ++i) {
                    nodeToUse = nodeToUse.has(splitNames[i]) ? (ObjectNode)nodeToUse.get(splitNames[i]) : nodeToUse.putObject(splitNames[i]);
                }
            }
            nodeToUse.putPOJO(propertyName, beanProp.getField().getValue(value));
        }
        gen.writeStartObject();
        Iterator<Map.Entry<String, JsonNode>> fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry<String, JsonNode> field = fields.next();
            gen.writeFieldName(field.getKey());
            gen.writeTree(field.getValue());
        }
        AnnotatedMember anyGetter = this.beanDescription.findAnyGetter();
        if (anyGetter != null && anyGetter.getAnnotation(JsonAnyGetter.class).enabled()) {
            BeanProperty.Std anyProperty = new BeanProperty.Std(PropertyName.construct(anyGetter.getName()), anyGetter.getType(), null, anyGetter, PropertyMetadata.STD_OPTIONAL);
            JsonSerializer<Object> anySerializer = provider.findTypedValueSerializer(anyGetter.getType(), true, (BeanProperty)anyProperty);
            AnyGetterWriter anyGetterWriter = new AnyGetterWriter(anyProperty, anyGetter, anySerializer);
            try {
                anyGetterWriter.getAndSerialize(value, gen, provider);
            }
            catch (IOException exception) {
                throw LOGGER.logThrowableAsError(exception);
            }
            catch (Exception exception) {
                throw LOGGER.logThrowableAsError(new IOException(exception));
            }
        }
        gen.writeEndObject();
    }

    private void classLevelFlattenSerialize(Object value, JsonGenerator gen) throws IOException {
        FlatteningSerializer.escapeMapKeys(value, LOGGER);
        ObjectNode root = (ObjectNode)this.mapper.valueToTree(value);
        ObjectNode res = root.deepCopy();
        LinkedBlockingQueue<ObjectNode> source = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> target = new LinkedBlockingQueue<ObjectNode>();
        source.add(root);
        target.add(res);
        while (!source.isEmpty()) {
            ObjectNode current = (ObjectNode)source.poll();
            ObjectNode resCurrent = (ObjectNode)target.poll();
            Iterator<Map.Entry<String, JsonNode>> fields = current.fields();
            while (fields.hasNext()) {
                Map.Entry<String, JsonNode> field = fields.next();
                ObjectNode node = resCurrent;
                String key = field.getKey();
                JsonNode outNode = resCurrent.get(key);
                if (CHECK_IF_FLATTEN_PROPERTY_PATTERN.matcher(key).matches()) {
                    String[] values = UNESCAPED_PERIOD_PATTERN.split(key);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].replace("\\.", ".");
                        if (i == values.length - 1) break;
                        String val2 = values[i];
                        if (node.has(val2)) {
                            node = (ObjectNode)node.get(val2);
                            continue;
                        }
                        ObjectNode child = new ObjectNode(JsonNodeFactory.instance);
                        node.set(val2, child);
                        node = child;
                    }
                    node.set(values[values.length - 1], resCurrent.get(key));
                    resCurrent.remove(key);
                    outNode = node.get(values[values.length - 1]);
                } else if (CHECK_IF_ESCAPED_MAP_PATTERN.matcher(key).matches()) {
                    String originalKey = REPLACE_ESCAPED_MAP_PATTERN.matcher(key).replaceAll(".");
                    resCurrent.remove(key);
                    resCurrent.set(originalKey, outNode);
                }
                if (field.getValue() instanceof ObjectNode) {
                    source.add((ObjectNode)field.getValue());
                    target.add((ObjectNode)outNode);
                    continue;
                }
                if (!(field.getValue() instanceof ArrayNode) || field.getValue().size() <= 0 || !(field.getValue().get(0) instanceof ObjectNode)) continue;
                Iterator<JsonNode> sourceIt = field.getValue().elements();
                Iterator<JsonNode> targetIt = outNode.elements();
                while (sourceIt.hasNext()) {
                    source.add((ObjectNode)sourceIt.next());
                    target.add((ObjectNode)targetIt.next());
                }
            }
        }
        gen.writeTree(res);
    }
}

