/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.polling.implementation;

import com.azure.core.implementation.TypeUtil;
import com.azure.core.util.BinaryData;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.net.URI;
import java.net.URISyntaxException;
import reactor.core.publisher.Mono;

public final class PollingUtils {
    private static final String FORWARD_SLASH = "/";

    public static Mono<BinaryData> serializeResponse(Object response, ObjectSerializer serializer) {
        if (response instanceof BinaryData) {
            return Mono.just((BinaryData)response);
        }
        return BinaryData.fromObjectAsync(response, serializer);
    }

    public static BinaryData serializeResponseSync(Object response, ObjectSerializer serializer) {
        if (response instanceof BinaryData) {
            return (BinaryData)response;
        }
        return BinaryData.fromObject(response, serializer);
    }

    public static <T> Mono<T> deserializeResponse(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (TypeUtil.isTypeOrSubTypeOf(BinaryData.class, typeReference.getJavaType())) {
            return binaryData.toReplayableBinaryDataAsync();
        }
        return binaryData.toObjectAsync(typeReference, serializer);
    }

    public static <T> T deserializeResponseSync(BinaryData binaryData, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (TypeUtil.isTypeOrSubTypeOf(BinaryData.class, typeReference.getJavaType())) {
            return (T)binaryData.toReplayableBinaryData();
        }
        return binaryData.toObject(typeReference, serializer);
    }

    public static <T> Mono<T> convertResponse(Object response, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (response == null) {
            return Mono.empty();
        }
        if (TypeUtil.isTypeOrSubTypeOf(response.getClass(), typeReference.getJavaType())) {
            return Mono.just(response);
        }
        return PollingUtils.serializeResponse(response, serializer).flatMap(binaryData -> PollingUtils.deserializeResponse(binaryData, serializer, typeReference));
    }

    public static <T> T convertResponseSync(Object response, ObjectSerializer serializer, TypeReference<T> typeReference) {
        if (response == null) {
            return null;
        }
        if (TypeUtil.isTypeOrSubTypeOf(response.getClass(), typeReference.getJavaType())) {
            return (T)response;
        }
        return PollingUtils.deserializeResponseSync(PollingUtils.serializeResponseSync(response, serializer), serializer, typeReference);
    }

    public static String getAbsolutePath(String path, String endpoint, ClientLogger logger2) {
        try {
            URI uri = new URI(path);
            if (!uri.isAbsolute()) {
                if (CoreUtils.isNullOrEmpty(endpoint)) {
                    throw logger2.logExceptionAsError(new IllegalArgumentException("Relative path requires endpoint to be non-null and non-empty to create an absolute path."));
                }
                if (endpoint.endsWith(FORWARD_SLASH) && path.startsWith(FORWARD_SLASH)) {
                    return endpoint + path.substring(1);
                }
                if (!endpoint.endsWith(FORWARD_SLASH) && !path.startsWith(FORWARD_SLASH)) {
                    return endpoint + FORWARD_SLASH + path;
                }
                return endpoint + path;
            }
        }
        catch (URISyntaxException ex) {
            throw logger2.logExceptionAsWarning(new IllegalArgumentException("'path' must be a valid URI.", ex));
        }
        return path;
    }

    private PollingUtils() {
    }
}

