/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.caffeine;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import java.util.EnumMap;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.checkerframework.checker.index.qual.NonNegative;

public final class MetricsStatsCounter
implements StatsCounter {
    private final Counter hitCount;
    private final Counter missCount;
    private final Timer loadSuccess;
    private final Timer loadFailure;
    private final Histogram evictions;
    private final Counter evictionWeight;
    private final EnumMap<RemovalCause, Histogram> evictionsWithCause;
    private final LongAdder totalLoadTime = new LongAdder();

    public MetricsStatsCounter(MetricRegistry registry, String metricsPrefix) {
        Objects.requireNonNull(metricsPrefix);
        this.hitCount = registry.counter(MetricRegistry.name(metricsPrefix, "hits"));
        this.missCount = registry.counter(MetricRegistry.name(metricsPrefix, "misses"));
        this.loadSuccess = registry.timer(MetricRegistry.name(metricsPrefix, "loads-success"));
        this.loadFailure = registry.timer(MetricRegistry.name(metricsPrefix, "loads-failure"));
        this.evictions = registry.histogram(MetricRegistry.name(metricsPrefix, "evictions"));
        this.evictionWeight = registry.counter(MetricRegistry.name(metricsPrefix, "evictions-weight"));
        this.evictionsWithCause = new EnumMap(RemovalCause.class);
        for (RemovalCause cause : RemovalCause.values()) {
            this.evictionsWithCause.put(cause, registry.histogram(MetricRegistry.name(metricsPrefix, "evictions", cause.name())));
        }
    }

    @Override
    public void recordHits(int count) {
        this.hitCount.inc(count);
    }

    @Override
    public void recordMisses(int count) {
        this.missCount.inc(count);
    }

    @Override
    public void recordLoadSuccess(long loadTime) {
        this.loadSuccess.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    @Override
    public void recordLoadFailure(long loadTime) {
        this.loadFailure.update(loadTime, TimeUnit.NANOSECONDS);
        this.totalLoadTime.add(loadTime);
    }

    @Override
    @Deprecated
    public void recordEviction() {
        this.recordEviction(1);
    }

    @Override
    @Deprecated
    public void recordEviction(int weight) {
        this.evictions.update(weight);
        this.evictionWeight.inc(weight);
    }

    @Override
    public void recordEviction(@NonNegative int weight, RemovalCause cause) {
        this.evictionsWithCause.get((Object)cause).update(weight);
        this.evictionWeight.inc(weight);
    }

    @Override
    public CacheStats snapshot() {
        return CacheStats.of(this.hitCount.getCount(), this.missCount.getCount(), this.loadSuccess.getCount(), this.loadFailure.getCount(), this.totalLoadTime.sum(), this.evictions.getCount(), this.evictionWeight.getCount());
    }

    public String toString() {
        return this.snapshot().toString();
    }
}

