/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient5;

import com.codahale.metrics.MetricRegistry;
import java.util.Objects;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.util.TimeValue;

public class InstrumentedAsyncClientConnectionManager
extends PoolingAsyncClientConnectionManager {
    private static final String METRICS_PREFIX = AsyncClientConnectionManager.class.getName();
    private final MetricRegistry metricsRegistry;
    private final String name;

    protected static Registry<TlsStrategy> getDefaultTlsStrategy() {
        return RegistryBuilder.create().register(URIScheme.HTTPS.id, DefaultClientTlsStrategy.getDefault()).build();
    }

    InstrumentedAsyncClientConnectionManager(MetricRegistry metricRegistry, String name, Lookup<TlsStrategy> tlsStrategyLookup, PoolConcurrencyPolicy poolConcurrencyPolicy, PoolReusePolicy poolReusePolicy, TimeValue timeToLive, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        super(tlsStrategyLookup, poolConcurrencyPolicy, poolReusePolicy, timeToLive, schemePortResolver, dnsResolver);
        this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
        this.name = name;
        metricRegistry.registerGauge(MetricRegistry.name(METRICS_PREFIX, name, "available-connections"), () -> this.getTotalStats().getAvailable());
        metricRegistry.registerGauge(MetricRegistry.name(METRICS_PREFIX, name, "leased-connections"), () -> this.getTotalStats().getLeased());
        metricRegistry.registerGauge(MetricRegistry.name(METRICS_PREFIX, name, "max-connections"), () -> this.getTotalStats().getMax());
        metricRegistry.registerGauge(MetricRegistry.name(METRICS_PREFIX, name, "pending-connections"), () -> this.getTotalStats().getPending());
    }

    @Override
    public void close() {
        this.close(CloseMode.GRACEFUL);
    }

    @Override
    public void close(CloseMode closeMode) {
        super.close(closeMode);
        this.metricsRegistry.remove(MetricRegistry.name(METRICS_PREFIX, this.name, "available-connections"));
        this.metricsRegistry.remove(MetricRegistry.name(METRICS_PREFIX, this.name, "leased-connections"));
        this.metricsRegistry.remove(MetricRegistry.name(METRICS_PREFIX, this.name, "max-connections"));
        this.metricsRegistry.remove(MetricRegistry.name(METRICS_PREFIX, this.name, "pending-connections"));
    }

    public static Builder builder(MetricRegistry metricsRegistry) {
        return new Builder().metricsRegistry(metricsRegistry);
    }

    public static class Builder {
        private MetricRegistry metricsRegistry;
        private String name;
        private Lookup<TlsStrategy> tlsStrategyLookup = InstrumentedAsyncClientConnectionManager.getDefaultTlsStrategy();
        private SchemePortResolver schemePortResolver;
        private DnsResolver dnsResolver;
        private PoolConcurrencyPolicy poolConcurrencyPolicy;
        private PoolReusePolicy poolReusePolicy;
        private TimeValue timeToLive = TimeValue.NEG_ONE_MILLISECOND;

        Builder() {
        }

        public Builder metricsRegistry(MetricRegistry metricRegistry) {
            this.metricsRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder schemePortResolver(SchemePortResolver schemePortResolver) {
            this.schemePortResolver = schemePortResolver;
            return this;
        }

        public Builder dnsResolver(DnsResolver dnsResolver) {
            this.dnsResolver = dnsResolver;
            return this;
        }

        public Builder timeToLive(TimeValue timeToLive) {
            this.timeToLive = timeToLive;
            return this;
        }

        public Builder tlsStrategyLookup(Lookup<TlsStrategy> tlsStrategyLookup) {
            this.tlsStrategyLookup = tlsStrategyLookup;
            return this;
        }

        public Builder poolConcurrencyPolicy(PoolConcurrencyPolicy poolConcurrencyPolicy) {
            this.poolConcurrencyPolicy = poolConcurrencyPolicy;
            return this;
        }

        public Builder poolReusePolicy(PoolReusePolicy poolReusePolicy) {
            this.poolReusePolicy = poolReusePolicy;
            return this;
        }

        public InstrumentedAsyncClientConnectionManager build() {
            return new InstrumentedAsyncClientConnectionManager(this.metricsRegistry, this.name, this.tlsStrategyLookup, this.poolConcurrencyPolicy, this.poolReusePolicy, this.timeToLive, this.schemePortResolver, this.dnsResolver);
        }
    }
}

