/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.httpclient5;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategies;
import com.codahale.metrics.httpclient5.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient5.InstrumentedAsyncClientConnectionManager;
import com.codahale.metrics.httpclient5.InstrumentedAsyncExecChainHandler;
import org.apache.hc.client5.http.impl.ChainElement;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClientBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;

public class InstrumentedHttpAsyncClients {
    private InstrumentedHttpAsyncClients() {
    }

    public static CloseableHttpAsyncClient createDefault(MetricRegistry metricRegistry) {
        return InstrumentedHttpAsyncClients.createDefault(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static CloseableHttpAsyncClient createDefault(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpAsyncClients.custom(metricRegistry, metricNameStrategy).build();
    }

    public static HttpAsyncClientBuilder custom(MetricRegistry metricRegistry) {
        return InstrumentedHttpAsyncClients.custom(metricRegistry, HttpClientMetricNameStrategies.METHOD_ONLY);
    }

    public static HttpAsyncClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy) {
        return InstrumentedHttpAsyncClients.custom(metricRegistry, metricNameStrategy, InstrumentedAsyncClientConnectionManager.builder(metricRegistry).build());
    }

    public static HttpAsyncClientBuilder custom(MetricRegistry metricRegistry, HttpClientMetricNameStrategy metricNameStrategy, AsyncClientConnectionManager clientConnectionManager) {
        return HttpAsyncClientBuilder.create().setConnectionManager(clientConnectionManager).addExecInterceptorBefore(ChainElement.CONNECT.name(), "dropwizard-metrics", new InstrumentedAsyncExecChainHandler(metricRegistry, metricNameStrategy));
    }
}

