/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi3;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jdbi3.strategies.SmartNameStrategy;
import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import java.sql.SQLException;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;

public class InstrumentedSqlLogger
implements SqlLogger {
    private final MetricRegistry registry;
    private final StatementNameStrategy statementNameStrategy;

    public InstrumentedSqlLogger(MetricRegistry registry) {
        this(registry, new SmartNameStrategy());
    }

    public InstrumentedSqlLogger(MetricRegistry registry, StatementNameStrategy statementNameStrategy) {
        this.registry = registry;
        this.statementNameStrategy = statementNameStrategy;
    }

    @Override
    public void logAfterExecution(StatementContext context) {
        this.log(context);
    }

    @Override
    public void logException(StatementContext context, SQLException ex) {
        this.log(context);
    }

    private void log(StatementContext context) {
        String statementName = this.statementNameStrategy.getStatementName(context);
        if (statementName != null) {
            long elapsed = context.getElapsedTime(ChronoUnit.NANOS);
            this.registry.timer(statementName).update(elapsed, TimeUnit.NANOSECONDS);
        }
    }
}

