/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jdbi3.strategies;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.annotation.Timed;
import com.codahale.metrics.jdbi3.strategies.StatementNameStrategy;
import java.lang.reflect.Method;
import org.jdbi.v3.core.extension.ExtensionMethod;
import org.jdbi.v3.core.statement.StatementContext;

public class TimedAnnotationNameStrategy
implements StatementNameStrategy {
    @Override
    public String getStatementName(StatementContext statementContext) {
        ExtensionMethod extensionMethod = statementContext.getExtensionMethod();
        if (extensionMethod == null) {
            return null;
        }
        Class<?> clazz = extensionMethod.getType();
        Timed classTimed = clazz.getAnnotation(Timed.class);
        Method method = extensionMethod.getMethod();
        Timed methodTimed = method.getAnnotation(Timed.class);
        if (methodTimed != null) {
            String methodName;
            String string = methodName = methodTimed.name().isEmpty() ? method.getName() : methodTimed.name();
            if (methodTimed.absolute()) {
                return methodName;
            }
            return classTimed == null || classTimed.name().isEmpty() ? MetricRegistry.name(clazz, methodName) : MetricRegistry.name(classTimed.name(), methodName);
        }
        if (classTimed != null) {
            return classTimed.name().isEmpty() ? MetricRegistry.name(clazz, method.getName()) : MetricRegistry.name(classTimed.name(), method.getName());
        }
        return null;
    }
}

