/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gbase.client;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class FeedURLFactory {
    public static final String DEFAULT_BASE_URL = "http://www.google.com/base/";
    private URL baseUrl;
    private URL feedSnippets;
    private URL feedItems;
    private URL feedItemsBatch;
    private URL feedLocales;
    private URL feedAttributes;
    private URL feedSnippetsBatch;
    private static final FeedURLFactory instance = new FeedURLFactory();

    public static FeedURLFactory getDefault() {
        return instance;
    }

    private FeedURLFactory() {
        try {
            this.init(DEFAULT_BASE_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected malformed URL", e);
        }
    }

    public FeedURLFactory(String url) throws MalformedURLException {
        this.init(url);
    }

    private void init(String url) throws MalformedURLException {
        this.baseUrl = new URL(url);
        this.feedSnippets = new URL(this.baseUrl, "feeds/snippets/");
        this.feedSnippetsBatch = new URL(this.baseUrl, "feeds/snippets/batch");
        this.feedItems = new URL(this.baseUrl, "feeds/items/");
        this.feedItemsBatch = new URL(this.baseUrl, "feeds/items/batch");
        this.feedLocales = new URL(this.baseUrl, "feeds/locales/");
        this.feedAttributes = new URL(this.baseUrl, "feeds/attributes/");
    }

    public URL getBaseURL() {
        return this.baseUrl;
    }

    private String encode(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported by the JVM", e);
        }
    }

    public URL getSnippetsFeedURL() {
        return this.feedSnippets;
    }

    public URL getSnippetsBatchFeedURL() {
        return this.feedSnippetsBatch;
    }

    public URL getSnippetsEntryURL(String id) throws MalformedURLException {
        if (id == null) {
            throw new NullPointerException("entryId is null");
        }
        return new URL(this.feedSnippets, this.encode(id));
    }

    public URL getItemsFeedURL() {
        return this.feedItems;
    }

    public URL getItemsEntryURL(String entryId) throws MalformedURLException {
        if (entryId == null) {
            throw new NullPointerException("entryId is null");
        }
        return new URL(this.feedItems, this.encode(entryId));
    }

    public URL getItemsBatchFeedURL() {
        return this.feedItemsBatch;
    }

    public URL getLocalesFeedURL() {
        return this.feedLocales;
    }

    public URL getItemTypesFeedURL(String locale) throws MalformedURLException {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        return new URL(this.baseUrl, "feeds/itemtypes/" + this.encode(locale));
    }

    public URL getItemTypesEntryURL(String locale, String itemType) throws MalformedURLException {
        if (locale == null) {
            throw new NullPointerException("locale is null");
        }
        if (itemType == null) {
            throw new NullPointerException("itemType is null");
        }
        return new URL(this.baseUrl, "feeds/itemtypes/" + this.encode(locale) + "/" + this.encode(itemType));
    }

    public URL getAttributesFeedURL() {
        return this.feedAttributes;
    }
}

