/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.authn.oauth;

import com.google.gdata.client.authn.oauth.OAuthException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OAuthParameters {
    public static final String OAUTH_CALLBACK_KEY = "oauth_callback";
    public static final String OAUTH_CONSUMER_KEY = "oauth_consumer_key";
    public static final String OAUTH_CONSUMER_SECRET = "oauth_consumer_secret";
    public static final String OAUTH_NONCE_KEY = "oauth_nonce";
    public static final String OAUTH_KEY = "OAuth";
    public static final String OAUTH_SIGNATURE_KEY = "oauth_signature";
    public static final String OAUTH_SIGNATURE_METHOD_KEY = "oauth_signature_method";
    public static final String OAUTH_TIMESTAMP_KEY = "oauth_timestamp";
    public static final String OAUTH_TOKEN_KEY = "oauth_token";
    public static final String OAUTH_TOKEN_SECRET_KEY = "oauth_token_secret";
    public static final String OAUTH_VERIFIER_KEY = "oauth_verifier";
    public static final String REALM_KEY = "realm";
    public static final String XOAUTH_REQUESTOR_ID_KEY = "xoauth_requestor_id";
    protected Map<String, String> baseParameters;
    protected Map<String, String> extraParameters;
    private OAuthType oauthType = OAuthType.THREE_LEGGED_OAUTH;

    public OAuthParameters() {
        this.baseParameters = new HashMap<String, String>();
        this.extraParameters = new HashMap<String, String>();
    }

    public Map<String, String> getBaseParameters() {
        return Collections.unmodifiableMap(this.baseParameters);
    }

    public Map<String, String> getExtraParameters() {
        return Collections.unmodifiableMap(this.extraParameters);
    }

    public void addCustomBaseParameter(String key, String value) {
        this.put(key, value, this.baseParameters);
    }

    public void removeCustomBaseParameter(String key) {
        this.remove(key, this.baseParameters);
    }

    public void addExtraParameter(String key, String value) {
        this.put(key, value, this.extraParameters);
    }

    public void reset() {
        this.remove(OAUTH_NONCE_KEY, this.baseParameters);
        this.remove(OAUTH_TIMESTAMP_KEY, this.baseParameters);
        this.remove(OAUTH_VERIFIER_KEY, this.baseParameters);
        this.remove(OAUTH_SIGNATURE_KEY, this.extraParameters);
    }

    public String getOAuthConsumerKey() {
        return this.get(OAUTH_CONSUMER_KEY, this.baseParameters);
    }

    public void setOAuthConsumerKey(String consumerKey) {
        this.put(OAUTH_CONSUMER_KEY, consumerKey, this.baseParameters);
    }

    public boolean checkOAuthConsumerKeyExists() {
        return this.checkExists(OAUTH_CONSUMER_KEY, this.baseParameters);
    }

    public void assertOAuthConsumerKeyExists() throws OAuthException {
        this.assertExists(OAUTH_CONSUMER_KEY, this.baseParameters);
    }

    public String getOAuthConsumerSecret() {
        return this.get(OAUTH_CONSUMER_SECRET, this.extraParameters);
    }

    public void setOAuthConsumerSecret(String consumerSecret) {
        this.put(OAUTH_CONSUMER_SECRET, consumerSecret, this.extraParameters);
    }

    public boolean checkOAuthConsumerSecretExists() {
        return this.checkExists(OAUTH_CONSUMER_SECRET, this.extraParameters);
    }

    public void assertOAuthConsumerSecretExists() throws OAuthException {
        this.assertExists(OAUTH_CONSUMER_SECRET, this.extraParameters);
    }

    public String getOAuthNonce() {
        return this.get(OAUTH_NONCE_KEY, this.baseParameters);
    }

    public void setOAuthNonce(String oauthNonce) {
        this.put(OAUTH_NONCE_KEY, oauthNonce, this.baseParameters);
    }

    public boolean checkOAuthNonceExists() {
        return this.checkExists(OAUTH_NONCE_KEY, this.baseParameters);
    }

    public void assertOAuthNonceExists() throws OAuthException {
        this.assertExists(OAUTH_NONCE_KEY, this.baseParameters);
    }

    public String getOAuthSignature() {
        return this.get(OAUTH_SIGNATURE_KEY, this.extraParameters);
    }

    public void setOAuthSignature(String signature) {
        this.put(OAUTH_SIGNATURE_KEY, signature, this.extraParameters);
    }

    public boolean checkOAuthSignatureExists() {
        return this.checkExists(OAUTH_SIGNATURE_KEY, this.extraParameters);
    }

    public void assertOAuthSignatureExists() throws OAuthException {
        this.assertExists(OAUTH_SIGNATURE_KEY, this.extraParameters);
    }

    public String getOAuthSignatureMethod() {
        return this.get(OAUTH_SIGNATURE_METHOD_KEY, this.baseParameters);
    }

    public void setOAuthSignatureMethod(String signatureMethod) {
        this.put(OAUTH_SIGNATURE_METHOD_KEY, signatureMethod, this.baseParameters);
    }

    public boolean checkOAuthSignatureMethodExists() {
        return this.checkExists(OAUTH_SIGNATURE_METHOD_KEY, this.baseParameters);
    }

    public void assertOAuthSignatureMethodExists() throws OAuthException {
        this.assertExists(OAUTH_SIGNATURE_METHOD_KEY, this.baseParameters);
    }

    public String getOAuthTimestamp() {
        return this.get(OAUTH_TIMESTAMP_KEY, this.baseParameters);
    }

    public void setOAuthTimestamp(String timestamp) {
        this.put(OAUTH_TIMESTAMP_KEY, timestamp, this.baseParameters);
    }

    public boolean checkOAuthTimestampExists() {
        return this.checkExists(OAUTH_TIMESTAMP_KEY, this.baseParameters);
    }

    public void assertOAuthTimestampExists() throws OAuthException {
        this.assertExists(OAUTH_TIMESTAMP_KEY, this.baseParameters);
    }

    public String getOAuthToken() {
        return this.get(OAUTH_TOKEN_KEY, this.baseParameters);
    }

    public void setOAuthToken(String token) {
        this.put(OAUTH_TOKEN_KEY, token, this.baseParameters);
    }

    public boolean checkOAuthTokenExists() {
        return this.checkExists(OAUTH_TOKEN_KEY, this.baseParameters);
    }

    public void assertOAuthTokenExists() throws OAuthException {
        this.assertExists(OAUTH_TOKEN_KEY, this.baseParameters);
    }

    public String getOAuthTokenSecret() {
        return this.get(OAUTH_TOKEN_SECRET_KEY, this.extraParameters);
    }

    public void setOAuthTokenSecret(String tokenSecret) {
        this.put(OAUTH_TOKEN_SECRET_KEY, tokenSecret, this.extraParameters);
    }

    public boolean checkOAuthTokenSecretExists() {
        return this.checkExists(OAUTH_TOKEN_SECRET_KEY, this.extraParameters);
    }

    public void assertOAuthTokenSecretExists() throws OAuthException {
        this.assertExists(OAUTH_TOKEN_SECRET_KEY, this.extraParameters);
    }

    public OAuthType getOAuthType() {
        return this.oauthType;
    }

    public void setOAuthType(OAuthType type) {
        this.oauthType = type;
    }

    public String getOAuthVerifier() {
        return this.get(OAUTH_VERIFIER_KEY, this.baseParameters);
    }

    public void setOAuthVerifier(String verifier) {
        this.put(OAUTH_VERIFIER_KEY, verifier, this.baseParameters);
    }

    public boolean checkOAuthVerifierExists() {
        return this.checkExists(OAUTH_VERIFIER_KEY, this.baseParameters);
    }

    public void assertOAuthVerifierExists() throws OAuthException {
        this.assertExists(OAUTH_VERIFIER_KEY, this.baseParameters);
    }

    public String getOAuthCallback() {
        return this.get(OAUTH_CALLBACK_KEY, this.extraParameters);
    }

    public void setOAuthCallback(String oauthCallback) {
        this.put(OAUTH_CALLBACK_KEY, oauthCallback, this.extraParameters);
    }

    public boolean checkOAuthCallbackExists() {
        return this.checkExists(OAUTH_CALLBACK_KEY, this.extraParameters);
    }

    public void assertOAuthCallbackExists() throws OAuthException {
        this.assertExists(OAUTH_CALLBACK_KEY, this.extraParameters);
    }

    public String getRealm() {
        return this.get(REALM_KEY, this.extraParameters);
    }

    public void setRealm(String realm) {
        this.put(REALM_KEY, realm, this.extraParameters);
    }

    public boolean checkRealmExists() {
        return this.checkExists(REALM_KEY, this.extraParameters);
    }

    public void assertRealmExists() throws OAuthException {
        this.assertExists(REALM_KEY, this.extraParameters);
    }

    protected String get(String key, Map<String, String> params) {
        String s2 = params.get(key);
        return s2 == null ? "" : s2;
    }

    protected void put(String key, String value, Map<String, String> params) {
        params.put(key, value);
    }

    protected void remove(String key, Map<String, String> params) {
        params.remove(key);
    }

    protected boolean checkExists(String key, Map<String, String> params) {
        return this.get(key, params).length() > 0;
    }

    protected void assertExists(String key, Map<String, String> params) throws OAuthException {
        if (!this.checkExists(key, params)) {
            throw new OAuthException(key + " does not exist.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OAuthType {
        TWO_LEGGED_OAUTH,
        THREE_LEGGED_OAUTH;

    }
}

