/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.calendar;

import com.google.gdata.client.Query;
import com.google.gdata.data.DateTime;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CalendarQuery
extends Query {
    public static final String MINIMUM_START_TIME = "start-min";
    public static final String MAXIMUM_START_TIME = "start-max";
    public static final String EXT_PROP_QUERY = "extq";
    private static final ExtendedPropertyMatch[] EMPTY_EXT_PROP_MATCH = new ExtendedPropertyMatch[0];

    public CalendarQuery(URL feedUrl) {
        super(feedUrl);
    }

    public void setMinimumStartTime(DateTime minStart) {
        List<Query.CustomParameter> customParams = this.getCustomParameters();
        for (Query.CustomParameter existingValue : this.getCustomParameters(MINIMUM_START_TIME)) {
            customParams.remove(existingValue);
        }
        if (minStart != null) {
            customParams.add(new Query.CustomParameter(MINIMUM_START_TIME, minStart.toString()));
        }
    }

    public DateTime getMinimumStartTime() {
        List<Query.CustomParameter> minParams = this.getCustomParameters(MINIMUM_START_TIME);
        if (minParams.size() == 0) {
            return null;
        }
        return DateTime.parseDateTime(minParams.get(0).getValue());
    }

    public void setMaximumStartTime(DateTime maxStart) {
        List<Query.CustomParameter> customParams = this.getCustomParameters();
        for (Query.CustomParameter existingValue : this.getCustomParameters(MAXIMUM_START_TIME)) {
            customParams.remove(existingValue);
        }
        if (maxStart != null) {
            customParams.add(new Query.CustomParameter(MAXIMUM_START_TIME, maxStart.toString()));
        }
    }

    public DateTime getMaximumStartTime() {
        List<Query.CustomParameter> maxParams = this.getCustomParameters(MAXIMUM_START_TIME);
        if (maxParams.size() == 0) {
            return null;
        }
        return DateTime.parseDateTime(maxParams.get(0).getValue());
    }

    public void setExtendedPropertyQuery(ExtendedPropertyMatch ... matches) {
        if (matches == null || matches.length == 0) {
            this.setStringCustomParameter(EXT_PROP_QUERY, null);
            return;
        }
        StringBuilder query = new StringBuilder();
        for (ExtendedPropertyMatch m4 : matches) {
            query.append(m4.toString());
        }
        this.setStringCustomParameter(EXT_PROP_QUERY, query.toString());
    }

    public ExtendedPropertyMatch[] getExtendedPropertyQuery() {
        String query = this.getStringCustomParameter(EXT_PROP_QUERY);
        if (query == null) {
            return EMPTY_EXT_PROP_MATCH;
        }
        return ExtendedPropertyMatch.arrayFromExtendedPropertyQueryString(query);
    }

    public static class ExtendedPropertyMatch {
        public static final int MAX_EXTENDED_PROPERTY_NAME_LENGTH = 44;
        public static final int MAX_EXTENDED_PROPERTY_VALUE_LENGTH = 1024;
        public static final String PROPERTY_NAME_REGEX = "[^:=]+";
        public static final String PROPERTY_VALUE_REGEX = "\\\"(?:[^\\\"\\\\]|(?:\\\\\\\\)|(?:\\\\\\\"))*\\\"|[^\\]]*";
        public static final String SINGLE_EXT_PROP_QUERY_REGEX = "\\[([^:=]+):(\\\"(?:[^\\\"\\\\]|(?:\\\\\\\\)|(?:\\\\\\\"))*\\\"|[^\\]]*)\\]";
        public static final Pattern EXT_PROP_QUERY_PATTERN = Pattern.compile("\\[([^:=]+):(\\\"(?:[^\\\"\\\\]|(?:\\\\\\\\)|(?:\\\\\\\"))*\\\"|[^\\]]*)\\]");
        private String name;
        private String expr;

        public ExtendedPropertyMatch(String name, String value) {
            if (name == null) {
                throw new NullPointerException("Property name is null");
            }
            if (value == null) {
                throw new NullPointerException("Property value is null");
            }
            if (name.length() > 44) {
                throw new IllegalArgumentException("Property name length in characters must not be more than 44");
            }
            if (value.length() > 1024) {
                throw new IllegalArgumentException("Property value length in characters must not be more than 1024");
            }
            this.name = name;
            this.expr = value;
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expr;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append('[').append(this.name).append(':');
            this.appendExpr(sb);
            sb.append(']');
            return sb.toString();
        }

        public boolean equals(Object other) {
            if (!(other instanceof ExtendedPropertyMatch)) {
                return false;
            }
            ExtendedPropertyMatch that = (ExtendedPropertyMatch)other;
            return ExtendedPropertyMatch.safeEquals(this.name, that.name) && ExtendedPropertyMatch.safeEquals(this.expr, that.expr);
        }

        public int hashCode() {
            return this.name.hashCode() * 257 + this.expr.hashCode() * 17;
        }

        private static boolean safeEquals(Object left, Object right) {
            return left == right || left != null && left.equals(right);
        }

        private void appendExpr(StringBuilder sb) {
            if (this.expr.contains("]") || this.expr.contains("\"")) {
                sb.append('\"').append(this.expr.replaceAll("\\\\", "\\\\\\\\").replaceAll("\\\"", "\\\\\"")).append('\"');
            } else {
                sb.append(this.expr);
            }
        }

        public static ExtendedPropertyMatch[] arrayFromExtendedPropertyQueryString(String extqQuery) {
            LinkedList<ExtendedPropertyMatch> result = new LinkedList<ExtendedPropertyMatch>();
            int startPos = 0;
            Matcher m4 = EXT_PROP_QUERY_PATTERN.matcher(extqQuery);
            while (startPos < extqQuery.length()) {
                if (!m4.find(startPos) || m4.start() != startPos) {
                    throw new IllegalArgumentException("Invalid extended property query:" + extqQuery);
                }
                startPos = m4.end();
                String propName = m4.group(1);
                String propValue = m4.group(2);
                if (propValue.startsWith("\"") && propValue.endsWith("\"")) {
                    propValue = propValue.substring(1, propValue.length() - 1).replaceAll("\\\\(.)", "$1");
                }
                result.add(new ExtendedPropertyMatch(propName, propValue));
            }
            return result.toArray(EMPTY_EXT_PROP_MATCH);
        }
    }
}

