/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.spreadsheet;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class FeedURLFactory {
    public static final String DEFAULT_SPREADSHEETS_URL = "https://spreadsheets.google.com";
    private static final String SPREADSHEETS_PATH = "feeds/spreadsheets/private/full";
    private static final String WORKSHEETS_PATH = "feeds/worksheets/";
    private static final String LIST_PATH = "feeds/list/";
    private static final String CELLS_PATH = "feeds/cells/";
    private static final String TABLE_PATH = "/tables/";
    private static final String RECORD_PATH = "/records/";
    private static final String BASE_PATH = "feeds/";
    private URL baseUrl;
    private URL feedSpreadsheets;
    private URL feedWorksheets;
    private URL feedList;
    private URL feedCells;
    private static final FeedURLFactory instance = new FeedURLFactory();

    public static FeedURLFactory getDefault() {
        return instance;
    }

    private FeedURLFactory() {
        try {
            this.init(DEFAULT_SPREADSHEETS_URL);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected malformed URL", e);
        }
    }

    public FeedURLFactory(String url) throws MalformedURLException {
        this.init(url);
    }

    private void init(String url) throws MalformedURLException {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.baseUrl = new URL(url);
        this.feedSpreadsheets = new URL(this.baseUrl, SPREADSHEETS_PATH);
        this.feedWorksheets = new URL(this.baseUrl, WORKSHEETS_PATH);
        this.feedList = new URL(this.baseUrl, LIST_PATH);
        this.feedCells = new URL(this.baseUrl, CELLS_PATH);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    private String encode(String s2) {
        try {
            return URLEncoder.encode(s2, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 is not supported by the JVM", e);
        }
    }

    public URL getSpreadsheetsFeedUrl() {
        return this.feedSpreadsheets;
    }

    public URL getWorksheetFeedUrl(String spreadsheetKey, String visibility, String projection) throws MalformedURLException {
        if (spreadsheetKey == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        return this.makeUrl(this.feedWorksheets, this.encode(spreadsheetKey), visibility, projection);
    }

    public URL getTableFeedUrl(String spreadsheetKey) throws MalformedURLException {
        if (spreadsheetKey == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        return new URL(this.baseUrl, BASE_PATH + this.encode(spreadsheetKey) + TABLE_PATH);
    }

    public URL getRecordFeedUrl(String spreadsheetKey, String tableId) throws MalformedURLException {
        if (spreadsheetKey == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        return new URL(this.baseUrl, BASE_PATH + this.encode(spreadsheetKey) + RECORD_PATH + tableId);
    }

    public URL getListFeedUrl(String spreadsheetKey, String worksheetId, String visibility, String projection) throws MalformedURLException {
        return this.makeUrl(this.feedList, spreadsheetKey, worksheetId, visibility, projection);
    }

    public URL getCellFeedUrl(String spreadsheetKey, String worksheetId, String visibility, String projection) throws MalformedURLException {
        return this.makeUrl(this.feedCells, spreadsheetKey, worksheetId, visibility, projection);
    }

    private URL makeUrl(URL url, String spreadsheetKey, String parentResourceId, String visibility, String projection) throws MalformedURLException {
        if (spreadsheetKey == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        if (parentResourceId == null) {
            throw new NullPointerException("worksheetId is null");
        }
        String path = this.encode(spreadsheetKey) + "/" + this.encode(parentResourceId);
        return this.makeUrl(url, path, visibility, projection);
    }

    private URL makeUrl(URL url, String path, String visibility, String projection) throws MalformedURLException {
        if (visibility == null) {
            throw new NullPointerException("visibility is null");
        }
        if (projection == null) {
            throw new NullPointerException("projection is null");
        }
        path = path + "/" + this.encode(visibility) + "/" + this.encode(projection);
        return new URL(url, path);
    }

    public static String getSpreadsheetKeyFromUrl(String url) throws IllegalArgumentException {
        block7: {
            try {
                URL urlAsUrl = new URL(url);
                String query = urlAsUrl.getQuery();
                if (query != null) {
                    String[] dottedParts;
                    String[] parts = query.split("&");
                    int offset = -1;
                    int numParts = 0;
                    String keyOrId = "";
                    for (String part : parts) {
                        if (part.startsWith("id=")) {
                            offset = "id=".length();
                            keyOrId = part.substring(offset);
                            numParts = 4;
                            break;
                        }
                        if (!part.startsWith("key=")) continue;
                        offset = "key=".length();
                        keyOrId = part.substring(offset);
                        if (keyOrId.startsWith("p")) {
                            return keyOrId;
                        }
                        numParts = 2;
                        break;
                    }
                    if (offset > -1 && (dottedParts = keyOrId.split("\\.")).length == numParts) {
                        return dottedParts[0] + "." + dottedParts[1];
                    }
                }
            }
            catch (MalformedURLException e) {
                String[] dottedParts = url.split("\\.");
                if (dottedParts.length != 4 && dottedParts.length != 2) break block7;
                return dottedParts[0] + "." + dottedParts[1];
            }
        }
        throw new IllegalArgumentException("Uknown URL format.");
    }
}

