/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.client.CoreErrorDomain;
import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.BaseFeed;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionManifest;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.Kind;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.base.Pair;
import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeSet;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionProfile {
    private HashSet<Class<? extends Kind.Adaptor>> declared = new HashSet();
    private final Map<Class<?>, ExtensionManifest> profile = new HashMap();
    private Collection<XmlNamespace> additionalNamespaces = new LinkedHashSet<XmlNamespace>();
    private ExtensionProfile feedLinkProfile;
    private ExtensionProfile entryLinkProfile;
    private Collection<XmlNamespace> nsDecls = null;
    private boolean isAutoExtending = false;
    private boolean allowsArbitraryXml = true;

    public void addDeclarations(Kind.Adaptor adaptor) {
        Class<?> adaptorClass = adaptor.getClass();
        if (this.declared.add(adaptorClass)) {
            adaptor.declareExtensions(this);
        }
    }

    private Class<? extends ExtensionPoint> extensionPointClass(Class clazz) {
        return clazz;
    }

    public synchronized void declare(Class<? extends ExtensionPoint> extendedType, ExtensionDescription extDescription) {
        boolean wasRequirednessRemoved = false;
        while (this.isAutoExtending && Kind.Adaptable.class.isAssignableFrom(extendedType.getSuperclass())) {
            if (!wasRequirednessRemoved && extDescription.isRequired()) {
                wasRequirednessRemoved = true;
                extDescription = new ExtensionDescription(extDescription.getExtensionClass(), extDescription.getNamespace(), extDescription.getLocalName(), false, extDescription.isRepeatable(), extDescription.isAggregate(), extDescription.allowsArbitraryXml(), extDescription.allowsMixedContent());
            }
            extendedType = this.extensionPointClass(extendedType.getSuperclass());
        }
        ExtensionManifest manifest = this.getOrCreateManifest(extendedType);
        this.profile.put(extendedType, manifest);
        Pair<String, String> extensionQName = new Pair<String, String>(extDescription.getNamespace().getUri(), extDescription.getLocalName());
        manifest.supportedExtensions.put(extensionQName, extDescription);
        for (ExtensionManifest subclassManifest : manifest.subclassManifests) {
            subclassManifest.supportedExtensions.put(extensionQName, extDescription);
        }
        if (extDescription.allowsArbitraryXml()) {
            Class<? extends Extension> extType = extDescription.getExtensionClass();
            ExtensionManifest extManifest = this.getOrCreateManifest(extType);
            this.profile.put(extType, extManifest);
            this.declareArbitraryXmlExtension(extType, extDescription.allowsMixedContent());
        }
        this.nsDecls = null;
    }

    public synchronized void declare(Class<? extends ExtensionPoint> extendedType, Class<? extends Extension> extClass) {
        this.declare(extendedType, ExtensionDescription.getDefaultDescription(extClass));
    }

    @Deprecated
    public synchronized void declareFeedExtension(ExtensionDescription extDesc) {
        this.declare(BaseFeed.class, extDesc);
    }

    @Deprecated
    public synchronized void declareFeedExtension(Class<? extends Extension> extClass) {
        this.declare(BaseFeed.class, extClass);
    }

    @Deprecated
    public synchronized void declareEntryExtension(ExtensionDescription extDesc) {
        this.declare(BaseEntry.class, extDesc);
    }

    @Deprecated
    public synchronized void declareEntryExtension(Class<? extends Extension> extClass) {
        this.declare(BaseEntry.class, extClass);
    }

    public synchronized void declareArbitraryXmlExtension(Class<? extends ExtensionPoint> extendedType) {
        this.declareArbitraryXmlExtension(extendedType, false);
    }

    public synchronized void declareArbitraryXmlExtension(Class<? extends ExtensionPoint> extendedType, boolean mixedContent) {
        ExtensionManifest manifest = this.getOrCreateManifest(extendedType);
        manifest.arbitraryXml = true;
        manifest.mixedContent = mixedContent;
        for (ExtensionManifest subclassManifest : manifest.subclassManifests) {
            subclassManifest.arbitraryXml = true;
            subclassManifest.mixedContent = mixedContent;
        }
        this.profile.put(extendedType, manifest);
        this.nsDecls = null;
    }

    public synchronized void declareAdditionalNamespace(XmlNamespace ns) {
        this.additionalNamespaces.add(ns);
    }

    public synchronized void declareFeedLinkProfile(ExtensionProfile profile) {
        this.feedLinkProfile = profile;
        this.nsDecls = null;
    }

    public synchronized ExtensionProfile getFeedLinkProfile() {
        return this.feedLinkProfile;
    }

    public synchronized void declareEntryLinkProfile(ExtensionProfile profile) {
        this.entryLinkProfile = profile;
        this.nsDecls = null;
    }

    public synchronized ExtensionProfile getEntryLinkProfile() {
        return this.entryLinkProfile;
    }

    public ExtensionManifest getManifest(Class<?> extendedType) {
        ExtensionManifest manifest = null;
        while (extendedType != null) {
            manifest = this.profile.get(extendedType);
            if (manifest != null) {
                return manifest;
            }
            extendedType = extendedType.getSuperclass();
        }
        return null;
    }

    public boolean isDeclared(Class<?> extendedType) {
        return this.profile.containsKey(extendedType);
    }

    public synchronized Collection<XmlNamespace> getNamespaceDecls() {
        if (this.nsDecls == null) {
            this.nsDecls = this.computeNamespaceDecls();
        }
        return this.nsDecls;
    }

    public void setAutoExtending(boolean v) {
        this.isAutoExtending = v;
    }

    public boolean isAutoExtending() {
        return this.isAutoExtending;
    }

    public void setArbitraryXml(boolean v) {
        this.allowsArbitraryXml = v;
    }

    public boolean allowsArbitraryXml() {
        return this.allowsArbitraryXml;
    }

    private ExtensionManifest getOrCreateManifest(Class<? extends ExtensionPoint> extendedType) {
        ExtensionManifest manifest = this.getManifest(extendedType);
        if (manifest != null && manifest.extendedType == extendedType) {
            return manifest;
        }
        ExtensionManifest newManifest = new ExtensionManifest(extendedType);
        Stack<ExtensionManifest> superManifests = new Stack<ExtensionManifest>();
        while (manifest != null) {
            superManifests.push(manifest);
            manifest = this.getManifest(manifest.extendedType.getSuperclass());
        }
        while (!superManifests.empty()) {
            ExtensionManifest superManifest = (ExtensionManifest)superManifests.pop();
            newManifest.supportedExtensions.putAll(superManifest.supportedExtensions);
            newManifest.arbitraryXml = superManifest.arbitraryXml;
            superManifest.subclassManifests.add(newManifest);
        }
        for (Map.Entry<Class<?>, ExtensionManifest> profileMapping : this.profile.entrySet()) {
            if (!extendedType.isAssignableFrom(profileMapping.getKey())) continue;
            newManifest.subclassManifests.add(profileMapping.getValue());
        }
        return newManifest;
    }

    private synchronized Collection<XmlNamespace> computeNamespaceDecls() {
        HashSet<XmlNamespace> result = new HashSet<XmlNamespace>();
        result.addAll(this.additionalNamespaces);
        for (ExtensionManifest manifest : this.profile.values()) {
            result.addAll(manifest.getNamespaceDecls());
        }
        if (this.feedLinkProfile != null) {
            result.addAll(this.feedLinkProfile.computeNamespaceDecls());
        }
        if (this.entryLinkProfile != null) {
            result.addAll(this.entryLinkProfile.computeNamespaceDecls());
        }
        return Collections.unmodifiableSet(result);
    }

    public void parseConfig(ExtensionProfile configProfile, ClassLoader classLoader, InputStream stream) throws IOException, ParseException {
        Handler handler = new Handler(configProfile, classLoader, null);
        new XmlParser().parse(stream, (XmlParser.ElementHandler)handler, "http://schemas.google.com/gdata/config/2005", "extensionProfile");
    }

    public void generateConfig(XmlWriter w, ExtensionProfile extProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> epAttrs = new ArrayList<XmlWriter.Attribute>();
        epAttrs.add(new XmlWriter.Attribute("arbitraryXml", this.allowsArbitraryXml));
        w.startElement(Namespaces.gdataConfigNs, "extensionProfile", epAttrs, this.nsDecls);
        for (XmlNamespace namespace : this.additionalNamespaces) {
            ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
            arrayList.add(new XmlWriter.Attribute("alias", namespace.getAlias()));
            arrayList.add(new XmlWriter.Attribute("uri", namespace.getUri()));
            w.simpleElement(Namespaces.gdataConfigNs, "namespaceDescription", arrayList, null);
        }
        TreeSet extensionSet = new TreeSet(new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        for (Class<?> clazz : this.profile.keySet()) {
            extensionSet.add(clazz);
        }
        for (Class<Object> clazz : extensionSet) {
            ExtensionManifest manifest = this.profile.get(clazz);
            ArrayList<XmlWriter.Attribute> ptAttrs = new ArrayList<XmlWriter.Attribute>();
            ptAttrs.add(new XmlWriter.Attribute("extendedClass", clazz.getName()));
            ptAttrs.add(new XmlWriter.Attribute("arbitraryXml", manifest.arbitraryXml));
            w.startElement(Namespaces.gdataConfigNs, "extensionPoint", ptAttrs, null);
            TreeSet<ExtensionDescription> descSet = new TreeSet<ExtensionDescription>();
            for (ExtensionDescription extDescription : manifest.getSupportedExtensions().values()) {
                descSet.add(extDescription);
            }
            for (ExtensionDescription extDescription : descSet) {
                extDescription.generateConfig(w, extProfile);
            }
            w.endElement(Namespaces.gdataConfigNs, "extensionPoint");
        }
        w.endElement(Namespaces.gdataConfigNs, "extensionProfile");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ExtensionPointHandler
    extends XmlParser.ElementHandler {
        private ExtensionProfile configProfile;
        private ClassLoader configLoader;
        private Class<? extends ExtensionPoint> extensionPoint;
        private boolean arbitraryXml;
        private List<ExtensionDescription> extDescriptions = new ArrayList<ExtensionDescription>();
        private List<XmlNamespace> namespaces;

        public ExtensionPointHandler(ExtensionProfile configProfile, ClassLoader configLoader, List<XmlNamespace> namespaces, Attributes attrs) throws ParseException {
            Class<?> loadedClass;
            this.configProfile = configProfile;
            this.configLoader = configLoader;
            this.namespaces = namespaces;
            String extendedClassName = attrs.getValue("", "extendedClass");
            if (extendedClassName == null) {
                ParseException pe = new ParseException(CoreErrorDomain.ERR.missingAttribute);
                pe.setInternalReason("ExtensionPoint extendedClass attribute is missing");
                throw pe;
            }
            try {
                loadedClass = configLoader.loadClass(extendedClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException(CoreErrorDomain.ERR.cantLoadExtensionPoint, (Throwable)e);
            }
            if (!ExtensionPoint.class.isAssignableFrom(loadedClass)) {
                throw new ParseException(CoreErrorDomain.ERR.mustExtendExtensionPoint);
            }
            this.extensionPoint = ExtensionProfile.this.extensionPointClass(loadedClass);
            Boolean val2 = this.getBooleanAttribute(attrs, "arbitraryXml");
            if (val2 != null) {
                this.arbitraryXml = val2;
            }
        }

        @Override
        public void processEndElement() {
            if (this.arbitraryXml) {
                ExtensionProfile.this.declareArbitraryXmlExtension(this.extensionPoint);
            }
            for (ExtensionDescription extDescription : this.extDescriptions) {
                ExtensionProfile.this.declare(this.extensionPoint, extDescription);
            }
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://schemas.google.com/gdata/config/2005") && localName.equals("extensionDescription")) {
                ExtensionDescription extDescription = new ExtensionDescription();
                this.extDescriptions.add(extDescription);
                ExtensionDescription extensionDescription = extDescription;
                extensionDescription.getClass();
                return extensionDescription.new ExtensionDescription.Handler(this.configProfile, this.configLoader, this.namespaces, attrs);
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }

    public class Handler
    extends XmlParser.ElementHandler {
        private ExtensionProfile configProfile;
        private ClassLoader configLoader;
        private List<XmlNamespace> namespaces = new ArrayList<XmlNamespace>();

        public Handler(ExtensionProfile configProfile, ClassLoader configLoader, Attributes attrs) throws ParseException {
            Boolean val2;
            this.configProfile = configProfile;
            this.configLoader = configLoader;
            if (attrs != null && (val2 = this.getBooleanAttribute(attrs, "arbitraryXml")) != null) {
                ExtensionProfile.this.allowsArbitraryXml = val2;
            }
        }

        public void validate() {
        }

        public void processEndElement() {
            this.validate();
        }

        public XmlParser.ElementHandler getChildHandler(String namespace, String localName, Attributes attrs) throws ParseException, IOException {
            if (namespace.equals("http://schemas.google.com/gdata/config/2005")) {
                if (localName.equals("namespaceDescription")) {
                    String alias = attrs.getValue("", "alias");
                    if (alias == null) {
                        ParseException pe = new ParseException(CoreErrorDomain.ERR.missingAttribute);
                        pe.setInternalReason("NamespaceDescription alias attribute is missing");
                        throw pe;
                    }
                    String uri = attrs.getValue("", "uri");
                    if (uri == null) {
                        ParseException pe = new ParseException(CoreErrorDomain.ERR.missingAttribute);
                        pe.setInternalReason("NamespaceDescription uri attribute is missing");
                        throw pe;
                    }
                    XmlNamespace declaredNs = new XmlNamespace(alias, uri);
                    this.namespaces.add(declaredNs);
                    ExtensionProfile.this.declareAdditionalNamespace(declaredNs);
                    return new XmlParser.ElementHandler();
                }
                if (localName.equals("extensionPoint")) {
                    return new ExtensionPointHandler(this.configProfile, this.configLoader, this.namespaces, attrs);
                }
            }
            return super.getChildHandler(namespace, localName, attrs);
        }
    }
}

