/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.analytics.AnalyticsLink;
import com.google.gdata.data.analytics.Dimension;
import com.google.gdata.data.analytics.Metric;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataEntry
extends BaseEntry<DataEntry> {
    public DataEntry() {
        this.setKind("analytics#datarow");
    }

    public DataEntry(BaseEntry<?> sourceEntry) {
        super(sourceEntry);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(DataEntry.class)) {
            return;
        }
        super.declareExtensions(extProfile);
        extProfile.declare(DataEntry.class, Dimension.getDefaultDescription(false, true));
        extProfile.declare(DataEntry.class, AnalyticsLink.getDefaultDescription(false, true));
        extProfile.declare(DataEntry.class, Metric.getDefaultDescription(false, true));
    }

    public List<Dimension> getDimensions() {
        return this.getRepeatingExtension(Dimension.class);
    }

    public void addDimension(Dimension dimension) {
        this.getDimensions().add(dimension);
    }

    public boolean hasDimensions() {
        return this.hasRepeatingExtension(Dimension.class);
    }

    public List<Metric> getMetrics() {
        return this.getRepeatingExtension(Metric.class);
    }

    public void addMetric(Metric metric) {
        this.getMetrics().add(metric);
    }

    public boolean hasMetrics() {
        return this.hasRepeatingExtension(Metric.class);
    }

    @Override
    protected void validate() {
    }

    public String toString() {
        return "{DataEntry " + super.toString() + "}";
    }

    public Dimension getDimension(String name) {
        List<Dimension> dimensions = this.getDimensions();
        for (Dimension dimension : dimensions) {
            if (!dimension.getName().equalsIgnoreCase(name)) continue;
            return dimension;
        }
        return null;
    }

    public Metric getMetric(String name) {
        List<Metric> metrics = this.getMetrics();
        for (Metric metric : metrics) {
            if (!metric.getName().equalsIgnoreCase(name)) continue;
            return metric;
        }
        return null;
    }

    public Long longValueOf(String name) {
        Metric m4 = this.getMetric(name);
        if (m4 == null) {
            return null;
        }
        return m4.longValue();
    }

    public Double doubleValueOf(String name) {
        Metric m4 = this.getMetric(name);
        if (m4 == null) {
            return null;
        }
        return m4.doubleValue();
    }

    public String stringValueOf(String name) {
        Dimension d = this.getDimension(name);
        if (d != null) {
            return d.getValue();
        }
        Metric m4 = this.getMetric(name);
        if (m4 != null) {
            return m4.getValue();
        }
        return null;
    }
}

