/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.analytics;

import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.analytics.Destination;
import com.google.gdata.data.analytics.Engagement;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="ga", nsUri="http://schemas.google.com/ga/2009", localName="goal")
public class Goal
extends ExtensionPoint {
    static final String XML_NAME = "goal";
    private static final String ACTIVE = "active";
    private static final String NAME = "name";
    private static final String NUMBER = "number";
    private static final String VALUE = "value";
    private Boolean active = null;
    private String name = null;
    private Integer number = null;
    private Double value = null;

    public Goal() {
    }

    public Goal(Boolean active, String name, Integer number, Double value) {
        this.setActive(active);
        this.setName(name);
        this.setNumber(number);
        this.setValue(value);
        this.setImmutable(true);
    }

    public void declareExtensions(ExtensionProfile extProfile) {
        if (extProfile.isDeclared(Goal.class)) {
            return;
        }
        extProfile.declare(Goal.class, Destination.class);
        new Destination().declareExtensions(extProfile);
        extProfile.declare(Goal.class, Engagement.class);
    }

    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.throwExceptionIfImmutable();
        this.active = active;
    }

    public boolean hasActive() {
        return this.getActive() != null;
    }

    public Destination getDestination() {
        return this.getExtension(Destination.class);
    }

    public void setDestination(Destination destination) {
        if (destination == null) {
            this.removeExtension(Destination.class);
        } else {
            this.setExtension(destination);
        }
    }

    public boolean hasDestination() {
        return this.hasExtension(Destination.class);
    }

    public Engagement getEngagement() {
        return this.getExtension(Engagement.class);
    }

    public void setEngagement(Engagement engagement) {
        if (engagement == null) {
            this.removeExtension(Engagement.class);
        } else {
            this.setExtension(engagement);
        }
    }

    public boolean hasEngagement() {
        return this.hasExtension(Engagement.class);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer number) {
        this.throwExceptionIfImmutable();
        this.number = number;
    }

    public boolean hasNumber() {
        return this.getNumber() != null;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.active == null) {
            Goal.throwExceptionForMissingAttribute(ACTIVE);
        }
        if (this.name == null) {
            Goal.throwExceptionForMissingAttribute(NAME);
        }
        if (this.number == null) {
            Goal.throwExceptionForMissingAttribute(NUMBER);
        }
        if (this.value == null) {
            Goal.throwExceptionForMissingAttribute(VALUE);
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Goal.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(ACTIVE, this.active);
        generator.put(NAME, this.name);
        generator.put(NUMBER, this.number);
        generator.put(VALUE, this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.active = helper.consumeBoolean(ACTIVE, true);
        this.name = helper.consume(NAME, true);
        this.number = helper.consumeInteger(NUMBER, true);
        this.value = helper.consumeDouble(VALUE, true);
    }

    public String toString() {
        return "{Goal active=" + this.active + " name=" + this.name + " number=" + this.number + " value=" + this.value + "}";
    }
}

