/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.contacts;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gContact", nsUri="http://schemas.google.com/contact/2008", localName="relation")
public class Relation
extends AbstractExtension {
    static final String XML_NAME = "relation";
    private static final String LABEL = "label";
    private static final String REL = "rel";
    private static final AttributeHelper.EnumToAttributeValue<Rel> REL_ENUM_TO_ATTRIBUTE_VALUE = new AttributeHelper.EnumToAttributeValue<Rel>(){

        @Override
        public String getAttributeValue(Rel enumValue) {
            return enumValue.toValue();
        }
    };
    private String label = null;
    private Rel rel = null;
    private String value = null;

    public Relation() {
    }

    public Relation(String label, Rel rel, String value) {
        this.setLabel(label);
        this.setRel(rel);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.throwExceptionIfImmutable();
        this.label = label;
    }

    public boolean hasLabel() {
        return this.getLabel() != null;
    }

    public Rel getRel() {
        return this.rel;
    }

    public void setRel(Rel rel) {
        this.throwExceptionIfImmutable();
        this.rel = rel;
    }

    public boolean hasRel() {
        return this.getRel() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(Relation.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(LABEL, this.label);
        generator.put(REL, this.rel, REL_ENUM_TO_ATTRIBUTE_VALUE);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.label = helper.consume(LABEL, false);
        this.rel = helper.consumeEnum(REL, false, Rel.class, null, REL_ENUM_TO_ATTRIBUTE_VALUE);
        this.value = helper.consume(null, false);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        Relation other = (Relation)obj;
        return Relation.eq(this.label, other.label) && Relation.eq((Object)this.rel, (Object)other.rel) && Relation.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.label != null) {
            result = 37 * result + this.label.hashCode();
        }
        if (this.rel != null) {
            result = 37 * result + this.rel.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{Relation label=" + this.label + " rel=" + (Object)((Object)this.rel) + " value=" + this.value + "}";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Rel {
        ASSISTANT("assistant"),
        BROTHER("brother"),
        CHILD("child"),
        DOMESTIC_PARTNER("domestic-partner"),
        FATHER("father"),
        FRIEND("friend"),
        MANAGER("manager"),
        MOTHER("mother"),
        PARENT("parent"),
        PARTNER("partner"),
        REFERRED_BY("referred-by"),
        RELATIVE("relative"),
        SISTER("sister"),
        SPOUSE("spouse");

        private final String value;

        private Rel(String value) {
            this.value = value;
        }

        public String toValue() {
            return this.value;
        }
    }
}

