/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.photos.impl;

import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.BoxDataImpl;
import com.google.gdata.data.geo.impl.PointDataImpl;
import com.google.gdata.data.media.mediarss.MediaCategory;
import com.google.gdata.data.media.mediarss.MediaContent;
import com.google.gdata.data.media.mediarss.MediaCredit;
import com.google.gdata.data.media.mediarss.MediaGroup;
import com.google.gdata.data.media.mediarss.MediaKeywords;
import com.google.gdata.data.media.mediarss.MediaThumbnail;
import com.google.gdata.data.photos.ExifTags;
import com.google.gdata.data.photos.GphotoAccess;
import com.google.gdata.data.photos.GphotoAlbumId;
import com.google.gdata.data.photos.GphotoChecksum;
import com.google.gdata.data.photos.GphotoClient;
import com.google.gdata.data.photos.GphotoCommentCount;
import com.google.gdata.data.photos.GphotoCommentsEnabled;
import com.google.gdata.data.photos.GphotoFeaturedDate;
import com.google.gdata.data.photos.GphotoHeight;
import com.google.gdata.data.photos.GphotoPosition;
import com.google.gdata.data.photos.GphotoRotation;
import com.google.gdata.data.photos.GphotoSize;
import com.google.gdata.data.photos.GphotoStarred;
import com.google.gdata.data.photos.GphotoStreamId;
import com.google.gdata.data.photos.GphotoTimestamp;
import com.google.gdata.data.photos.GphotoVersion;
import com.google.gdata.data.photos.GphotoVideoStatus;
import com.google.gdata.data.photos.GphotoViewCount;
import com.google.gdata.data.photos.GphotoWidth;
import com.google.gdata.data.photos.PhotoData;
import com.google.gdata.data.photos.impl.GphotoDataImpl;
import com.google.gdata.data.photos.impl.MediaDataImpl;
import com.google.gdata.data.photos.pheed.PheedImageUrl;
import com.google.gdata.data.photos.pheed.PheedThumbnail;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhotoDataImpl
extends GphotoDataImpl
implements PhotoData {
    private final PointDataImpl pointData;
    private final BoxDataImpl boundingBoxData;
    private final MediaDataImpl mediaData;

    public PhotoDataImpl(ExtensionPoint extensionPoint) {
        super(extensionPoint);
        this.pointData = new PointDataImpl(extensionPoint);
        this.boundingBoxData = new BoxDataImpl(extensionPoint);
        this.mediaData = new MediaDataImpl(extensionPoint);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        this.declare(extProfile, PheedThumbnail.getDefaultDescription());
        this.declare(extProfile, PheedImageUrl.getDefaultDescription());
        this.declare(extProfile, GphotoVersion.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoPosition.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoWidth.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoHeight.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoRotation.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoSize.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoAlbumId.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoAccess.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoClient.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoChecksum.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoTimestamp.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoStreamId.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoVideoStatus.getDefaultDescription(false, false));
        this.declare(extProfile, ExifTags.getDefaultDescription());
        new ExifTags().declareExtensions(extProfile);
        this.declare(extProfile, GphotoCommentsEnabled.getDefaultDescription(false, false));
        this.declare(extProfile, GphotoCommentCount.getDefaultDescription(false, false));
        this.pointData.declareExtensions(extProfile);
        this.boundingBoxData.declareExtensions(extProfile);
        this.mediaData.declareExtensions(extProfile);
    }

    @Override
    public Long getVersion() {
        GphotoVersion ext = this.getExtension(GphotoVersion.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setVersion(Long version) {
        if (version != null) {
            this.setExtension(new GphotoVersion(version));
        } else {
            this.removeExtension(GphotoVersion.class);
        }
    }

    @Override
    public Float getPosition() {
        GphotoPosition ext = this.getExtension(GphotoPosition.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setPosition(Float position) {
        if (position != null) {
            this.setExtension(new GphotoPosition(position));
        } else {
            this.removeExtension(GphotoPosition.class);
        }
    }

    @Override
    public String getAlbumId() {
        return this.getSimpleValue(GphotoAlbumId.class);
    }

    @Override
    public void setAlbumId(String albumId) {
        if (albumId != null) {
            this.setExtension(new GphotoAlbumId(albumId));
        } else {
            this.removeExtension(GphotoAlbumId.class);
        }
    }

    @Override
    public void setAlbumId(Long albumId) {
        if (albumId != null) {
            this.setExtension(new GphotoAlbumId(albumId.toString()));
        } else {
            this.removeExtension(GphotoAlbumId.class);
        }
    }

    @Override
    public String getAlbumAccess() {
        GphotoAccess access = this.getExtension(GphotoAccess.class);
        return access == null ? null : access.getValue().toLowerCase();
    }

    @Override
    public void setAlbumAccess(String access) {
        if (access != null) {
            this.setExtension(new GphotoAccess(access));
        } else {
            this.removeExtension(GphotoAccess.class);
        }
    }

    @Override
    public String getVideoStatus() {
        return this.getSimpleValue(GphotoVideoStatus.class);
    }

    @Override
    public void setVideoStatus(String videoStatus) {
        if (videoStatus != null) {
            this.setExtension(new GphotoVideoStatus(videoStatus));
        } else {
            this.removeExtension(GphotoVideoStatus.class);
        }
    }

    @Override
    public Long getWidth() {
        GphotoWidth ext = this.getExtension(GphotoWidth.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setWidth(Long width) {
        if (width != null) {
            this.setExtension(new GphotoWidth(width));
        } else {
            this.removeExtension(GphotoWidth.class);
        }
    }

    @Override
    public Long getHeight() {
        GphotoHeight ext = this.getExtension(GphotoHeight.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setHeight(Long height) {
        if (height != null) {
            this.setExtension(new GphotoHeight(height));
        } else {
            this.removeExtension(GphotoHeight.class);
        }
    }

    @Override
    public Integer getRotation() {
        GphotoRotation ext = this.getExtension(GphotoRotation.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setRotation(Integer rotation) {
        if (rotation != null) {
            this.setExtension(new GphotoRotation(rotation));
        } else {
            this.removeExtension(GphotoRotation.class);
        }
    }

    @Override
    public Long getSize() {
        GphotoSize ext = this.getExtension(GphotoSize.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setSize(Long size) {
        if (size != null) {
            this.setExtension(new GphotoSize(size));
        } else {
            this.removeExtension(GphotoSize.class);
        }
    }

    @Override
    public String getClient() {
        return this.getSimpleValue(GphotoClient.class);
    }

    @Override
    public void setClient(String client) {
        if (client != null) {
            this.setExtension(new GphotoClient(client));
        } else {
            this.removeExtension(GphotoClient.class);
        }
    }

    @Override
    public String getChecksum() {
        return this.getSimpleValue(GphotoChecksum.class);
    }

    @Override
    public void setChecksum(String checksum) {
        if (checksum != null) {
            this.setExtension(new GphotoChecksum(checksum));
        } else {
            this.removeExtension(GphotoChecksum.class);
        }
    }

    @Override
    public Date getTimestamp() {
        GphotoTimestamp ext = this.getExtension(GphotoTimestamp.class);
        return ext == null ? null : new Date(ext.getValue());
    }

    @Override
    public void setTimestamp(Date timestamp) {
        if (timestamp != null) {
            this.setExtension(new GphotoTimestamp(timestamp));
        } else {
            this.removeExtension(GphotoTimestamp.class);
        }
    }

    @Override
    public ExifTags getExifTags() {
        return this.getExtension(ExifTags.class);
    }

    @Override
    public void setExifTags(ExifTags tags) {
        if (tags != null) {
            this.setExtension(tags);
        } else {
            this.removeExtension(ExifTags.class);
        }
    }

    @Override
    public Boolean getCommentsEnabled() {
        GphotoCommentsEnabled ext = this.getExtension(GphotoCommentsEnabled.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setCommentsEnabled(Boolean commentsEnabled) {
        if (commentsEnabled != null) {
            this.setExtension(new GphotoCommentsEnabled(commentsEnabled));
        } else {
            this.removeExtension(GphotoCommentsEnabled.class);
        }
    }

    @Override
    public Integer getCommentCount() {
        GphotoCommentCount ext = this.getExtension(GphotoCommentCount.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setCommentCount(Integer commentCount) {
        if (commentCount != null) {
            this.setExtension(new GphotoCommentCount(commentCount));
        } else {
            this.removeExtension(GphotoCommentCount.class);
        }
    }

    @Override
    public List<String> getStreamIds() {
        List<GphotoStreamId> exts = this.getRepeatingExtension(GphotoStreamId.class);
        ArrayList<String> streamIds = new ArrayList<String>(exts.size());
        for (GphotoStreamId streamId : exts) {
            streamIds.add(streamId.getValue());
        }
        return streamIds;
    }

    @Override
    public void addStreamId(String streamId) {
        this.addRepeatingExtension(new GphotoStreamId(streamId));
    }

    @Override
    public Long getViewCount() {
        GphotoViewCount ext = this.getExtension(GphotoViewCount.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setViewCount(Long viewCount) {
        if (viewCount != null) {
            this.setExtension(new GphotoViewCount(viewCount));
        } else {
            this.removeExtension(GphotoViewCount.class);
        }
    }

    @Override
    public Date getFeaturedDate() {
        GphotoFeaturedDate ext = this.getExtension(GphotoFeaturedDate.class);
        return ext == null ? null : new Date(ext.getValue());
    }

    @Override
    public void setFeaturedDate(Date featuredDate) {
        if (featuredDate != null) {
            this.setExtension(new GphotoFeaturedDate(featuredDate));
        } else {
            this.removeExtension(GphotoFeaturedDate.class);
        }
    }

    @Override
    public void setGeoLocation(Double lat, Double lon) {
        this.pointData.setGeoLocation(lat, lon);
    }

    @Override
    public void setGeoLocation(Point point) {
        this.pointData.setGeoLocation(point);
    }

    @Override
    public Point getGeoLocation() {
        return this.pointData.getGeoLocation();
    }

    @Override
    public Box getGeoBoundingBox() {
        return this.boundingBoxData.getGeoBoundingBox();
    }

    @Override
    public void setGeoBoundingBox(Point lowerLeft, Point upperRight) {
        this.boundingBoxData.setGeoBoundingBox(lowerLeft, upperRight);
    }

    @Override
    public void setGeoBoundingBox(Box boundingBox) {
        this.boundingBoxData.setGeoBoundingBox(boundingBox);
    }

    @Override
    public void clearPoint() {
        this.pointData.clearPoint();
    }

    @Override
    public void clearGeoBoundingBox() {
        this.boundingBoxData.clearGeoBoundingBox();
    }

    @Override
    public MediaGroup getMediaGroup() {
        return this.mediaData.getMediaGroup();
    }

    @Override
    public List<MediaContent> getMediaContents() {
        return this.mediaData.getMediaContents();
    }

    @Override
    public List<MediaCategory> getMediaCategories() {
        return this.mediaData.getMediaCategories();
    }

    @Override
    public List<MediaCredit> getMediaCredits() {
        return this.mediaData.getMediaCredits();
    }

    @Override
    public List<MediaThumbnail> getMediaThumbnails() {
        return this.mediaData.getMediaThumbnails();
    }

    @Override
    public MediaKeywords getMediaKeywords() {
        return this.mediaData.getMediaKeywords();
    }

    @Override
    public void setKeywords(MediaKeywords keywords) {
        this.mediaData.setKeywords(keywords);
    }

    @Override
    public Boolean isStarred() {
        GphotoStarred ext = this.getExtension(GphotoStarred.class);
        return ext == null ? null : ext.getValue();
    }

    @Override
    public void setStarred(Boolean starred) {
        GphotoStarred ext = this.getExtension(GphotoStarred.class);
        if (ext == null) {
            ext = new GphotoStarred();
            this.setExtension(ext);
        }
        ext.setValue(starred);
    }

    @Override
    public Integer getTotalStars() {
        GphotoStarred ext = this.getExtension(GphotoStarred.class);
        return ext == null ? null : ext.getTotal();
    }

    @Override
    public void setTotalStars(Integer totalStars) {
        GphotoStarred ext = this.getExtension(GphotoStarred.class);
        if (ext == null) {
            ext = new GphotoStarred();
            this.setExtension(ext);
        }
        ext.setTotal(totalStars);
    }
}

