/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.webmastertools;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.extensions.EntryLink;
import com.google.gdata.data.webmastertools.BoolValueConstruct;
import com.google.gdata.data.webmastertools.DateTimeValueConstruct;
import com.google.gdata.data.webmastertools.Namespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageEntry
extends BaseEntry<MessageEntry> {
    private static final String LANGUAGE = "language";
    private static final String SUBJECT = "subject";
    private static final String DATE = "date";
    private static final String READ = "read";
    private static final String BODY = "body";
    private static final Category CATEGORY = Namespaces.createCategory("http://schemas.google.com/webmasters/tools/2007#message");

    public MessageEntry() {
        this.getCategories().add(CATEGORY);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        ExtensionDescription desc = EntryLink.getDefaultDescription();
        desc.setRepeatable(true);
        extProfile.declare(MessageEntry.class, desc);
        extProfile.declare(MessageEntry.class, ExtensionDescription.getDefaultDescription(LanguageExtension.class));
        extProfile.declare(MessageEntry.class, ExtensionDescription.getDefaultDescription(SubjectExtension.class));
        extProfile.declare(MessageEntry.class, ExtensionDescription.getDefaultDescription(DateExtension.class));
        extProfile.declare(MessageEntry.class, ExtensionDescription.getDefaultDescription(ReadExtension.class));
        extProfile.declare(MessageEntry.class, ExtensionDescription.getDefaultDescription(BodyExtension.class));
    }

    public void setLanguage(String language) {
        LanguageExtension languageExtension = this.getExtension(LanguageExtension.class);
        if (languageExtension == null) {
            languageExtension = new LanguageExtension();
            this.setExtension(languageExtension);
        }
        languageExtension.setValue(language);
    }

    public String getLanguage() {
        LanguageExtension languageExtension = this.getExtension(LanguageExtension.class);
        if (languageExtension == null) {
            return null;
        }
        return languageExtension.getValue();
    }

    public void setSubject(String subject) {
        SubjectExtension subjectExtension = this.getExtension(SubjectExtension.class);
        if (subjectExtension == null) {
            subjectExtension = new SubjectExtension();
            this.setExtension(subjectExtension);
        }
        subjectExtension.setValue(subject);
    }

    public String getSubject() {
        SubjectExtension subjectExtension = this.getExtension(SubjectExtension.class);
        if (subjectExtension == null) {
            return null;
        }
        return subjectExtension.getValue();
    }

    public void setDate(DateTime date) {
        DateExtension dateExtension = this.getExtension(DateExtension.class);
        if (dateExtension == null) {
            dateExtension = new DateExtension();
            this.setExtension(dateExtension);
        }
        dateExtension.setDateTime(date);
    }

    public DateTime getDate() {
        DateExtension dateExtension = this.getExtension(DateExtension.class);
        if (dateExtension == null) {
            return null;
        }
        return dateExtension.getDateTime();
    }

    public void setRead(boolean read) {
        ReadExtension readExtension = this.getExtension(ReadExtension.class);
        if (readExtension == null) {
            readExtension = new ReadExtension();
            this.setExtension(readExtension);
        }
        readExtension.setBooleanValue(read);
    }

    public boolean getRead() {
        ReadExtension readExtension = this.getExtension(ReadExtension.class);
        return readExtension != null && readExtension.getBooleanValue();
    }

    public void setBody(String body) {
        BodyExtension bodyExtension = this.getExtension(BodyExtension.class);
        if (bodyExtension == null) {
            bodyExtension = new BodyExtension();
            this.setExtension(bodyExtension);
        }
        bodyExtension.setValue(body);
    }

    public String getBody() {
        BodyExtension bodyExtension = this.getExtension(BodyExtension.class);
        if (bodyExtension == null) {
            return null;
        }
        return bodyExtension.getValue();
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="body")
    public static class BodyExtension
    extends ValueConstruct {
        public BodyExtension() {
            super(MessageEntry.BODY);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="read")
    public static class ReadExtension
    extends BoolValueConstruct {
        public ReadExtension() {
            super(MessageEntry.READ);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="date")
    public static class DateExtension
    extends DateTimeValueConstruct {
        public DateExtension() {
            super(MessageEntry.DATE);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="subject")
    public static class SubjectExtension
    extends ValueConstruct {
        public SubjectExtension() {
            super(MessageEntry.SUBJECT);
        }
    }

    @ExtensionDescription.Default(nsAlias="wt", nsUri="http://schemas.google.com/webmasters/tools/2007", localName="language")
    public static class LanguageExtension
    extends ValueConstruct {
        public LanguageExtension() {
            super(MessageEntry.LANGUAGE);
        }
    }
}

