/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.BaseEntry;
import com.google.gdata.data.Category;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.ILink;
import com.google.gdata.data.Kind;
import com.google.gdata.data.Link;
import com.google.gdata.data.extensions.FeedLink;
import com.google.gdata.data.youtube.EntryUtils;
import com.google.gdata.data.youtube.UserProfileEntry;
import com.google.gdata.data.youtube.YouTubeNamespace;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Kind.Term(value="http://gdata.youtube.com/schemas/2007#channel")
public class ChannelEntry
extends BaseEntry<ChannelEntry> {
    public static final String[] CATEGORIES = new String[]{"http://gdata.youtube.com/schemas/2007/channeltypes.cat"};

    public ChannelEntry() {
        EntryUtils.setKind(this, "http://gdata.youtube.com/schemas/2007#channel");
    }

    private Category getCategoryWithScheme(Set<Category> categories, String scheme) {
        for (Category c : categories) {
            if (!c.getScheme().equals(scheme)) continue;
            return c;
        }
        return null;
    }

    public String getChannelType() {
        return this.getCategoryWithScheme(this.getCategories(), "http://gdata.youtube.com/schemas/2007/channeltypes.cat").getTerm();
    }

    public void setChannelType(String channelTypeTerm) {
        if (channelTypeTerm == null) {
            this.getCategories().remove(this.getCategoryWithScheme(this.getCategories(), "http://gdata.youtube.com/schemas/2007/channeltypes.cat"));
            return;
        }
        this.getCategories().add(new Category("http://gdata.youtube.com/schemas/2007/channeltypes.cat", channelTypeTerm));
    }

    public FeedLink<?> getUploadsFeedLink() {
        return EntryUtils.getFeedLink(this, "http://gdata.youtube.com/schemas/2007#user.uploads");
    }

    public Link getFeaturedVideoLink() {
        return this.getLink("http://gdata.youtube.com/schemas/2007#featured-video", ILink.Type.ATOM);
    }

    @Override
    public void declareExtensions(ExtensionProfile extProfile) {
        super.declareExtensions(extProfile);
        extProfile.declareAdditionalNamespace(YouTubeNamespace.NS);
        ExtensionDescription feedLinkDescription = FeedLink.getDefaultDescription();
        feedLinkDescription.setRepeatable(true);
        extProfile.declare(UserProfileEntry.class, feedLinkDescription);
        extProfile.declareArbitraryXmlExtension(ChannelEntry.class);
    }
}

