/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.youtube;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.DateTime;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="yt", nsUri="http://gdata.youtube.com/schemas/2007", localName="uploaded")
public class YtUploaded
extends AbstractExtension {
    private DateTime dateTime;

    public YtUploaded() {
    }

    public YtUploaded(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(DateTime dateTime) {
        this.dateTime = dateTime;
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        super.consumeAttributes(helper);
        try {
            this.dateTime = DateTime.parseDateTime(helper.consumeContent(true));
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid date time format.");
        }
    }

    protected void putAttributes(AttributeGenerator generator) {
        super.putAttributes(generator);
        if (this.dateTime != null) {
            generator.setContent(this.dateTime.toString());
        }
    }
}

