/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.model;

import com.google.gdata.model.Metadata;
import com.google.gdata.model.MetadataCreatorImpl;
import com.google.gdata.model.Path;
import com.google.gdata.model.QName;
import com.google.gdata.model.TransformKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Transform {
    private final QName name;
    private final Boolean required;
    private final Boolean visible;
    private final Metadata.VirtualValue virtualValue;
    private final TransformKey source;
    private final Path path;
    private final boolean isMoved;

    Transform() {
        this.name = null;
        this.required = null;
        this.visible = null;
        this.virtualValue = null;
        this.source = null;
        this.path = null;
        this.isMoved = false;
    }

    Transform(MetadataCreatorImpl creator) {
        this.name = creator.getName();
        this.required = creator.getRequired();
        this.visible = creator.getVisible();
        this.virtualValue = creator.getVirtualValue();
        this.source = creator.getSource();
        this.path = creator.getPath();
        this.isMoved = creator.isMoved();
    }

    Transform(Iterable<? extends Transform> parts) {
        QName compositeName = null;
        Boolean compositeRequired = null;
        Boolean compositeVisible = null;
        Metadata.VirtualValue compositeVirtualValue = null;
        TransformKey compositeSource = null;
        Path compositePath = null;
        boolean compositeMoved = false;
        for (Transform transform : parts) {
            if (transform.name != null) {
                compositeName = transform.name;
            }
            if (transform.required != null) {
                compositeRequired = transform.required;
            }
            if (transform.visible != null) {
                compositeVisible = transform.visible;
            }
            if (transform.virtualValue != null) {
                compositeVirtualValue = transform.virtualValue;
            }
            if (transform.source != null) {
                compositeSource = transform.source;
            }
            if (transform.path != null) {
                compositePath = transform.path;
            }
            if (!transform.isMoved) continue;
            compositeMoved = true;
        }
        this.name = compositeName;
        this.required = compositeRequired;
        this.visible = compositeVisible;
        this.virtualValue = compositeVirtualValue;
        this.source = compositeSource;
        this.path = compositePath;
        this.isMoved = compositeMoved;
    }

    Transform(Transform transform, Transform source) {
        this.name = Transform.first(transform.name, source.name);
        this.required = transform.required;
        this.visible = Transform.first(transform.visible, source.visible);
        this.virtualValue = Transform.first(transform.virtualValue, source.virtualValue);
        this.path = transform.path;
        this.isMoved = transform.isMoved;
        this.source = null;
    }

    static <T> T first(T ... ts) {
        for (T t2 : ts) {
            if (t2 == null) continue;
            return t2;
        }
        return null;
    }

    QName getName() {
        return this.name;
    }

    Boolean getRequired() {
        return this.required;
    }

    Boolean getVisible() {
        return this.visible;
    }

    Metadata.VirtualValue getVirtualValue() {
        return this.virtualValue;
    }

    TransformKey getSource() {
        return this.source;
    }

    Path getPath() {
        return this.path;
    }

    boolean isMoved() {
        return this.isMoved;
    }

    boolean isEmpty() {
        return this.name == null && this.required == null && this.visible == null && this.virtualValue == null && this.source == null && this.path == null && !this.isMoved;
    }
}

