/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.logging.Logger;

public class LoggableInputStream
extends FilterInputStream {
    private final StringWriter sw = new StringWriter();
    private final Logger logger;
    private boolean closed = false;

    public LoggableInputStream(Logger logger2, InputStream stream) {
        super(stream);
        this.logger = logger2;
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.logger.finest(this.sw.toString());
            this.closed = true;
        }
        super.close();
    }

    public int read() throws IOException {
        int readInt = super.read();
        this.sw.write(readInt);
        return readInt;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = super.read(b, off, len);
        if (read > 0) {
            String s2 = new String(b, off, read);
            this.sw.write(s2);
        }
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = super.read(b);
        if (read > 0) {
            String s2 = new String(b, 0, read);
            this.sw.write(s2);
        }
        return read;
    }
}

