/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.parser;

import com.google.gdata.util.parser.Action;
import com.google.gdata.util.parser.Alternative;
import com.google.gdata.util.parser.Callback;
import com.google.gdata.util.parser.Difference;
import com.google.gdata.util.parser.Intersection;
import com.google.gdata.util.parser.Repeat;
import com.google.gdata.util.parser.Sequence;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Parser<T> {
    public static final int NO_MATCH = -1;

    public abstract int parse(char[] var1, int var2, int var3, T var4);

    public final int parse(char[] buf, T udata) {
        return this.parse(buf, 0, buf.length, udata);
    }

    public final int parse(String str, T udata) {
        return this.parse(str.toCharArray(), udata);
    }

    public final int parse(Reader reader, T udata) {
        CharArrayWriter writer = new CharArrayWriter();
        try {
            int count;
            char[] buf = new char[1024];
            while ((count = reader.read(buf)) >= 0) {
                writer.write(buf, 0, count);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return this.parse(writer.toCharArray(), udata);
    }

    public final Parser<T> repeat(int count) {
        return new Repeat(this, count, count);
    }

    public final Parser<T> repeat(int min2, int max) {
        return new Repeat(this, min2, max);
    }

    public final Parser<T> star() {
        return new Repeat(this, 0);
    }

    public final Parser<T> plus() {
        return new Repeat(this, 1);
    }

    public final Parser<T> optional() {
        return this.repeat(0, 1);
    }

    public final Parser<T> list(Parser<? super T> sep) {
        return Parser.sequence(this, Parser.sequence(sep, this).star());
    }

    public final <U extends T> Parser<U> action(Callback<U> callback) {
        return new Action(this, callback);
    }

    public static <T> Parser<T> alternative(Parser<? super T> left, Parser<? super T> right) {
        return new Alternative<T>(left, right);
    }

    public static <T> Parser<T> intersection(Parser<? super T> left, Parser<? super T> right) {
        return new Intersection<T>(left, right);
    }

    public static <T> Parser<T> difference(Parser<? super T> left, Parser<? super T> right) {
        return new Difference<T>(left, right);
    }

    public static <T> Parser<T> sequence(Parser<? super T> left, Parser<? super T> right) {
        return new Sequence<T>(left, right);
    }

    public static <T> Parser<T> sequence(Parser<? super T> one, Parser<? super T> two, Parser<? super T> three) {
        return Parser.sequence(one, Parser.sequence(two, three));
    }

    public static <T> Parser<T> sequence(Parser<? super T> one, Parser<? super T> two, Parser<? super T> three, Parser<? super T> four) {
        return Parser.sequence(one, Parser.sequence(two, Parser.sequence(three, four)));
    }

    public static <T> Parser<T> sequence(Parser<? super T> one, Parser<? super T> two, Parser<? super T> three, Parser<? super T> four, Parser<? super T> five) {
        return Parser.sequence(one, Parser.sequence(two, Parser.sequence(three, Parser.sequence(four, five))));
    }
}

