/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats.output;

import com.google.gdata.wireformats.output.OutputGenerator;
import com.google.gdata.wireformats.output.OutputProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CharacterGenerator<S>
implements OutputGenerator<S> {
    protected static String getCharsetEncoding(OutputProperties outProps) {
        String charset = null;
        if (outProps.getContentType() != null) {
            charset = outProps.getContentType().getCharset();
        }
        if (charset == null) {
            charset = "utf-8";
        }
        return charset;
    }

    protected Writer getContentWriter(OutputProperties outProps, OutputStream contentStream) throws IOException {
        String encoding = CharacterGenerator.getCharsetEncoding(outProps);
        return new OutputStreamWriter(contentStream, encoding);
    }

    @Override
    public void generate(OutputStream contentStream, OutputProperties outProps, S s2) throws IOException {
        Writer contentWriter = this.getContentWriter(outProps, contentStream);
        this.generate(contentWriter, outProps, s2);
    }

    public abstract void generate(Writer var1, OutputProperties var2, S var3) throws IOException;

    protected boolean usePrettyPrint(OutputProperties outProps) {
        return Boolean.parseBoolean(outProps.getQueryParameter("prettyprint"));
    }
}

