/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.JDBCType;
import com.microsoft.sqlserver.jdbc.JavaType;
import com.microsoft.sqlserver.jdbc.SQLServerDataColumn;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SSType;
import com.microsoft.sqlserver.jdbc.Util;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import microsoft.sql.DateTimeOffset;

public final class SQLServerDataTable {
    int rowCount = 0;
    int columnCount = 0;
    Map<Integer, SQLServerDataColumn> columnMetadata = new LinkedHashMap<Integer, SQLServerDataColumn>();
    Set<String> columnNames = new HashSet<String>();
    Map<Integer, Object[]> rows = new HashMap<Integer, Object[]>();
    private String tvpName = null;

    public synchronized void clear() {
        this.rowCount = 0;
        this.columnCount = 0;
        this.columnMetadata.clear();
        this.rows.clear();
    }

    public synchronized Iterator<Map.Entry<Integer, Object[]>> getIterator() {
        if (null != this.rows && null != this.rows.entrySet()) {
            return this.rows.entrySet().iterator();
        }
        return null;
    }

    public synchronized void addColumnMetadata(String columnName, int sqlType) throws SQLServerException {
        Util.checkDuplicateColumnName(columnName, this.columnNames);
        this.columnMetadata.put(this.columnCount++, new SQLServerDataColumn(columnName, sqlType));
    }

    public synchronized void addColumnMetadata(SQLServerDataColumn column) throws SQLServerException {
        Util.checkDuplicateColumnName(column.columnName, this.columnNames);
        this.columnMetadata.put(this.columnCount++, column);
    }

    public synchronized void addRow(Object ... values) throws SQLServerException {
        try {
            int columnCount = this.columnMetadata.size();
            if (null != values && values.length > columnCount) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_moreDataInRowThanColumnInTVP"));
                Object[] msgArgs = new Object[]{};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
            Iterator<Map.Entry<Integer, SQLServerDataColumn>> columnsIterator = this.columnMetadata.entrySet().iterator();
            Object[] rowValues = new Object[columnCount];
            int currentColumn = 0;
            while (columnsIterator.hasNext()) {
                Object val2 = null;
                if (null != values && currentColumn < values.length && null != values[currentColumn]) {
                    val2 = values[currentColumn];
                }
                ++currentColumn;
                Map.Entry<Integer, SQLServerDataColumn> pair = columnsIterator.next();
                JDBCType jdbcType = JDBCType.of(pair.getValue().javaSqlType);
                this.internalAddrow(jdbcType, val2, rowValues, pair);
            }
            this.rows.put(this.rowCount++, rowValues);
        }
        catch (NumberFormatException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
        catch (ClassCastException e) {
            throw new SQLServerException(SQLServerException.getErrString("R_TVPInvalidColumnValue"), e);
        }
    }

    private void internalAddrow(JDBCType jdbcType, Object val2, Object[] rowValues, Map.Entry<Integer, SQLServerDataColumn> pair) throws SQLServerException {
        SQLServerDataColumn currentColumnMetadata = pair.getValue();
        boolean isColumnMetadataUpdated = false;
        switch (jdbcType) {
            case BIGINT: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Long.valueOf(Long.parseLong(val2.toString()));
                break;
            }
            case BIT: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Boolean.valueOf(Boolean.parseBoolean(val2.toString()));
                break;
            }
            case INTEGER: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Integer.valueOf(Integer.parseInt(val2.toString()));
                break;
            }
            case SMALLINT: 
            case TINYINT: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Short.valueOf(Short.parseShort(val2.toString()));
                break;
            }
            case DECIMAL: 
            case NUMERIC: {
                BigDecimal bd = null;
                if (null != val2) {
                    int numberOfDigitsIntegerPart;
                    bd = new BigDecimal(val2.toString());
                    int precision = Util.getValueLengthBaseOnJavaType(bd, JavaType.of(bd), null, null, jdbcType);
                    if (bd.scale() > currentColumnMetadata.scale) {
                        currentColumnMetadata.scale = bd.scale();
                        isColumnMetadataUpdated = true;
                    }
                    if (precision > currentColumnMetadata.precision) {
                        currentColumnMetadata.precision = precision;
                        isColumnMetadataUpdated = true;
                    }
                    if ((numberOfDigitsIntegerPart = precision - bd.scale()) > currentColumnMetadata.numberOfDigitsIntegerPart) {
                        currentColumnMetadata.numberOfDigitsIntegerPart = numberOfDigitsIntegerPart;
                        isColumnMetadataUpdated = true;
                    }
                    if (isColumnMetadataUpdated) {
                        currentColumnMetadata.precision = currentColumnMetadata.scale + currentColumnMetadata.numberOfDigitsIntegerPart;
                        this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                    }
                }
                rowValues[pair.getKey().intValue()] = bd;
                break;
            }
            case DOUBLE: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Double.valueOf(Double.parseDouble(val2.toString()));
                break;
            }
            case FLOAT: 
            case REAL: {
                rowValues[pair.getKey().intValue()] = null == val2 ? null : Float.valueOf(Float.parseFloat(val2.toString()));
                break;
            }
            case TIMESTAMP_WITH_TIMEZONE: 
            case TIME_WITH_TIMEZONE: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case DATETIMEOFFSET: 
            case DATETIME: 
            case SMALLDATETIME: {
                if (null == val2) {
                    rowValues[pair.getKey().intValue()] = null;
                    break;
                }
                if (val2 instanceof Date) {
                    rowValues[pair.getKey().intValue()] = val2.toString();
                    break;
                }
                if (val2 instanceof DateTimeOffset) {
                    rowValues[pair.getKey().intValue()] = val2.toString();
                    break;
                }
                if (val2 instanceof OffsetDateTime) {
                    rowValues[pair.getKey().intValue()] = val2.toString();
                    break;
                }
                if (val2 instanceof OffsetTime) {
                    rowValues[pair.getKey().intValue()] = val2.toString();
                    break;
                }
                rowValues[pair.getKey().intValue()] = (String)val2;
                break;
            }
            case BINARY: 
            case VARBINARY: 
            case LONGVARBINARY: {
                int nValueLen;
                boolean bValueNull = null == val2;
                int n = nValueLen = bValueNull ? 0 : ((byte[])val2).length;
                if (nValueLen > currentColumnMetadata.precision) {
                    currentColumnMetadata.precision = nValueLen;
                    this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                }
                rowValues[pair.getKey().intValue()] = bValueNull ? null : (byte[])val2;
                break;
            }
            case CHAR: {
                if (val2 instanceof UUID && val2 != null) {
                    val2 = val2.toString();
                }
            }
            case VARCHAR: 
            case NCHAR: 
            case NVARCHAR: 
            case LONGVARCHAR: 
            case LONGNVARCHAR: 
            case SQLXML: {
                int nValueLen;
                boolean bValueNull = null == val2;
                int n = nValueLen = bValueNull ? 0 : 2 * ((String)val2).length();
                if (nValueLen > currentColumnMetadata.precision) {
                    currentColumnMetadata.precision = nValueLen;
                    this.columnMetadata.put(pair.getKey(), currentColumnMetadata);
                }
                rowValues[pair.getKey().intValue()] = bValueNull ? null : (String)val2;
                break;
            }
            case SQL_VARIANT: {
                if (null == val2) {
                    throw new SQLServerException(SQLServerException.getErrString("R_invalidValueForTVPWithSQLVariant"), null);
                }
                JavaType javaType = JavaType.of(val2);
                JDBCType internalJDBCType = javaType.getJDBCType(SSType.UNKNOWN, jdbcType);
                this.internalAddrow(internalJDBCType, val2, rowValues, pair);
                break;
            }
            default: {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_unsupportedDataTypeTVP"));
                Object[] msgArgs = new Object[]{jdbcType};
                throw new SQLServerException(null, form.format(msgArgs), null, 0, false);
            }
        }
    }

    public synchronized Map<Integer, SQLServerDataColumn> getColumnMetadata() {
        return this.columnMetadata;
    }

    public String getTvpName() {
        return this.tvpName;
    }

    public void setTvpName(String tvpName) {
        this.tvpName = tvpName;
    }
}

