/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CacheClear;
import com.microsoft.sqlserver.jdbc.EncryptionKeyInfo;
import com.microsoft.sqlserver.jdbc.SQLServerColumnEncryptionKeyStoreProvider;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerSymmetricKey;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Base64;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

final class SQLServerSymmetricKeyCache {
    static final Object lock = new Object();
    private final ConcurrentHashMap<String, SQLServerSymmetricKey> cache = new ConcurrentHashMap();
    private static final SQLServerSymmetricKeyCache instance = new SQLServerSymmetricKeyCache();
    private static ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t2 = Executors.defaultThreadFactory().newThread(r);
            t2.setDaemon(true);
            return t2;
        }
    });
    private static final Logger aeLogger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerSymmetricKeyCache");

    private SQLServerSymmetricKeyCache() {
    }

    static SQLServerSymmetricKeyCache getInstance() {
        return instance;
    }

    ConcurrentHashMap<String, SQLServerSymmetricKey> getCache() {
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SQLServerSymmetricKey getKey(EncryptionKeyInfo keyInfo, SQLServerConnection connection) throws SQLServerException {
        SQLServerSymmetricKey encryptionKey = null;
        Object object = lock;
        synchronized (object) {
            String serverName = connection.getTrustedServerNameAE();
            assert (null != serverName) : "serverName should not be null in getKey.";
            StringBuilder keyLookupValuebuffer = new StringBuilder(serverName);
            keyLookupValuebuffer.append(":");
            keyLookupValuebuffer.append(Base64.getEncoder().encodeToString(new String(keyInfo.encryptedKey, StandardCharsets.UTF_8).getBytes()));
            keyLookupValuebuffer.append(":");
            keyLookupValuebuffer.append(keyInfo.keyStoreName);
            String keyLookupValue = keyLookupValuebuffer.toString();
            keyLookupValuebuffer.setLength(0);
            if (aeLogger.isLoggable(Level.FINE)) {
                aeLogger.fine("Checking trusted master key path...");
            }
            Boolean[] hasEntry = new Boolean[1];
            List<String> trustedKeyPaths = SQLServerConnection.getColumnEncryptionTrustedMasterKeyPaths(serverName, hasEntry);
            if (hasEntry[0].booleanValue() && (null == trustedKeyPaths || 0 == trustedKeyPaths.size() || !trustedKeyPaths.contains(keyInfo.keyPath))) {
                MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UntrustedKeyPath"));
                Object[] msgArgs = new Object[]{keyInfo.keyPath, serverName};
                throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
            }
            if (aeLogger.isLoggable(Level.FINE)) {
                aeLogger.fine("Checking Symmetric key cache...");
            }
            if (!this.cache.containsKey(keyLookupValue)) {
                SQLServerColumnEncryptionKeyStoreProvider provider = connection.getSystemColumnEncryptionKeyStoreProvider(keyInfo.keyStoreName);
                if (null == provider) {
                    provider = SQLServerConnection.getGlobalSystemColumnEncryptionKeyStoreProvider(keyInfo.keyStoreName);
                }
                if (null == provider) {
                    provider = SQLServerConnection.getGlobalCustomColumnEncryptionKeyStoreProvider(keyInfo.keyStoreName);
                }
                if (null == provider) {
                    String systemProviders = connection.getAllSystemColumnEncryptionKeyStoreProviders();
                    String customProviders = SQLServerConnection.getAllGlobalCustomSystemColumnEncryptionKeyStoreProviders();
                    MessageFormat form = new MessageFormat(SQLServerException.getErrString("R_UnrecognizedKeyStoreProviderName"));
                    Object[] msgArgs = new Object[]{keyInfo.keyStoreName, systemProviders, customProviders};
                    throw new SQLServerException((Object)this, form.format(msgArgs), null, 0, false);
                }
                byte[] plaintextKey = provider.decryptColumnEncryptionKey(keyInfo.keyPath, keyInfo.algorithmName, keyInfo.encryptedKey);
                encryptionKey = new SQLServerSymmetricKey(plaintextKey);
                long columnEncryptionKeyCacheTtl = SQLServerConnection.getColumnEncryptionKeyCacheTtl();
                if (0L != columnEncryptionKeyCacheTtl) {
                    this.cache.putIfAbsent(keyLookupValue, encryptionKey);
                    if (aeLogger.isLoggable(Level.FINE)) {
                        aeLogger.fine("Adding encryption key to cache...");
                    }
                    scheduler.schedule(new CacheClear(keyLookupValue), columnEncryptionKeyCacheTtl, TimeUnit.SECONDS);
                }
            } else {
                encryptionKey = this.cache.get(keyLookupValue);
            }
        }
        return encryptionKey;
    }
}

