/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.TDSTimeoutTask;
import java.io.Serializable;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class SharedTimer
implements Serializable {
    private static final long serialVersionUID = -4069361613863955760L;
    static final String CORE_THREAD_PREFIX = "mssql-jdbc-shared-timer-core-";
    private static final AtomicLong CORE_THREAD_COUNTER = new AtomicLong();
    private static SharedTimer instance;
    private final long id = CORE_THREAD_COUNTER.getAndIncrement();
    private int refCount = 0;
    private ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, task -> {
        Thread t2 = new Thread(task, CORE_THREAD_PREFIX + this.id);
        t2.setDaemon(true);
        return t2;
    });

    private SharedTimer() {
        this.executor.setRemoveOnCancelPolicy(true);
    }

    public long getId() {
        return this.id;
    }

    static synchronized boolean isRunning() {
        return instance != null;
    }

    public synchronized void removeRef() {
        if (this.refCount <= 0) {
            throw new IllegalStateException("removeRef() called more than actual references");
        }
        --this.refCount;
        if (this.refCount == 0) {
            this.executor.shutdownNow();
            this.executor = null;
            instance = null;
        }
    }

    public static synchronized SharedTimer getTimer() {
        if (instance == null) {
            instance = new SharedTimer();
        }
        ++SharedTimer.instance.refCount;
        return instance;
    }

    public ScheduledFuture<?> schedule(TDSTimeoutTask task, long delaySeconds) {
        return this.schedule(task, delaySeconds, TimeUnit.SECONDS);
    }

    public ScheduledFuture<?> schedule(TDSTimeoutTask task, long delay, TimeUnit unit) {
        if (this.executor == null) {
            throw new IllegalStateException("Cannot schedule tasks after shutdown");
        }
        return this.executor.schedule(task, delay, unit);
    }
}

