/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.codahale.metrics.caffeine.MetricsStatsCounter;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.github.benmanes.caffeine.cache.stats.StatsCounter;
import io.dropwizard.auth.AuthorizationContext;
import io.dropwizard.auth.Authorizer;
import jakarta.ws.rs.container.ContainerRequestContext;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CachingAuthorizer<P extends Principal>
implements Authorizer<P> {
    private final Authorizer<P> underlying;
    private final Meter cacheMisses;
    private final Timer getsTimer;
    final LoadingCache<AuthorizationContext<P>, Boolean> cache;

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, CaffeineSpec cacheSpec) {
        this(metricRegistry, authorizer, Caffeine.from(cacheSpec));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, Caffeine<Object, Object> builder) {
        this(metricRegistry, authorizer, builder, () -> new MetricsStatsCounter(metricRegistry, MetricRegistry.name(CachingAuthorizer.class, new String[0])));
    }

    public CachingAuthorizer(MetricRegistry metricRegistry, Authorizer<P> authorizer, Caffeine<Object, Object> builder, Supplier<StatsCounter> supplier) {
        this.underlying = authorizer;
        this.cacheMisses = metricRegistry.meter(MetricRegistry.name(authorizer.getClass(), "cache-misses"));
        this.getsTimer = metricRegistry.timer(MetricRegistry.name(authorizer.getClass(), "gets"));
        this.cache = builder.recordStats(supplier).build(key -> {
            this.cacheMisses.mark();
            return this.underlying.authorize(key.getPrincipal(), key.getRole(), key.getRequestContext());
        });
    }

    @Override
    public boolean authorize(P principal, String role, @Nullable ContainerRequestContext requestContext) {
        Timer.Context context = this.getsTimer.time();
        try {
            AuthorizationContext<P> cacheKey = this.getAuthorizationContext(principal, role, requestContext);
            boolean bl = Boolean.TRUE.equals(this.cache.get(cacheKey));
            if (context != null) {
                context.close();
            }
            return bl;
        }
        catch (Throwable cacheKey) {
            try {
                if (context != null) {
                    try {
                        context.close();
                    }
                    catch (Throwable throwable) {
                        cacheKey.addSuppressed(throwable);
                    }
                }
                throw cacheKey;
            }
            catch (CompletionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw e;
            }
        }
    }

    @Override
    public AuthorizationContext<P> getAuthorizationContext(P principal, String role, @Nullable ContainerRequestContext requestContext) {
        return this.underlying.getAuthorizationContext(principal, role, requestContext);
    }

    public void invalidate(P principal, String role, ContainerRequestContext requestContext) {
        this.cache.invalidate(this.getAuthorizationContext(principal, role, requestContext));
    }

    public void invalidate(P principal) {
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> cacheKey.getPrincipal().equals(principal)).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll(Iterable<P> principals) {
        HashSet principalSet = new HashSet();
        principals.forEach(principalSet::add);
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> principalSet.contains(cacheKey.getPrincipal())).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll(Predicate<? super P> predicate) {
        Set keys = this.cache.asMap().keySet().stream().filter(cacheKey -> predicate.test((Object)cacheKey.getPrincipal())).collect(Collectors.toSet());
        this.cache.invalidateAll(keys);
    }

    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public CacheStats stats() {
        return this.cache.stats();
    }
}

