/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.auth;

import io.dropwizard.auth.Auth;
import io.dropwizard.auth.AuthInjectionHelper;
import io.dropwizard.auth.WebApplicationExceptionCatchingFilter;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.DynamicFeature;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.Map;
import java.util.Optional;
import org.glassfish.jersey.InjectionManagerProvider;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.model.AnnotatedMethod;

public class PolymorphicAuthDynamicFeature<T extends Principal>
implements Feature,
DynamicFeature {
    private final Map<Class<? extends T>, ContainerRequestFilter> authFilterMap;

    public PolymorphicAuthDynamicFeature(Map<Class<? extends T>, ContainerRequestFilter> authFilterMap) {
        this.authFilterMap = authFilterMap;
    }

    @Override
    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        AnnotatedMethod am = new AnnotatedMethod(resourceInfo.getResourceMethod());
        Annotation[][] parameterAnnotations = am.getParameterAnnotations();
        Class<?>[] parameterTypes = am.getParameterTypes();
        Type[] parameterGenericTypes = am.getGenericParameterTypes();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Class<?> type = parameterTypes[i];
            Class<?> paramType = type == Optional.class ? ((ParameterizedType)parameterGenericTypes[i]).getActualTypeArguments()[0] : type;
            for (Annotation annotation : parameterAnnotations[i]) {
                if (!(annotation instanceof Auth) || !this.authFilterMap.containsKey(paramType)) continue;
                ContainerRequestFilter filter = this.authFilterMap.get(paramType);
                context.register(type == Optional.class ? new WebApplicationExceptionCatchingFilter(filter) : filter);
                return;
            }
        }
    }

    @Override
    public boolean configure(FeatureContext context) {
        try {
            InjectionManager injectionManager = InjectionManagerProvider.getInjectionManager(context);
            if (injectionManager != null) {
                for (ContainerRequestFilter authFilter : this.authFilterMap.values()) {
                    AuthInjectionHelper.inject(injectionManager, authFilter);
                }
            }
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }
}

