/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.db;

import com.codahale.metrics.MetricRegistry;
import io.dropwizard.db.ManagedDataSource;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import org.apache.tomcat.jdbc.pool.ConnectionPool;
import org.apache.tomcat.jdbc.pool.DataSourceProxy;
import org.apache.tomcat.jdbc.pool.PoolConfiguration;

public class ManagedPooledDataSource
extends DataSourceProxy
implements ManagedDataSource {
    private final MetricRegistry metricRegistry;

    public ManagedPooledDataSource(PoolConfiguration config, MetricRegistry metricRegistry) {
        super(config);
        this.metricRegistry = metricRegistry;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Doesn't use java.util.logging");
    }

    @Override
    public void start() throws Exception {
        ConnectionPool connectionPool = this.createPool();
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "active"), connectionPool::getActive);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "idle"), connectionPool::getIdle);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "waiting"), connectionPool::getWaitCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "size"), connectionPool::getSize);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "created"), connectionPool::getCreatedCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "borrowed"), connectionPool::getBorrowedCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "reconnected"), connectionPool::getReconnectedCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "released"), connectionPool::getReleasedCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "releasedIdle"), connectionPool::getReleasedIdleCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "returned"), connectionPool::getReturnedCount);
        this.metricRegistry.register(MetricRegistry.name(this.getClass(), connectionPool.getName(), "removeAbandoned"), connectionPool::getRemoveAbandonedCount);
    }

    @Override
    public void stop() throws Exception {
        this.close();
    }
}

