/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.health.HealthCheckType;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;

public final class HealthStateView
implements Comparable<HealthStateView> {
    @NotNull
    @JsonProperty
    private String name;
    @JsonProperty
    private boolean healthy;
    @NotNull
    @JsonProperty
    private HealthCheckType type;
    @JsonProperty
    private boolean critical;

    public HealthStateView(@NotNull String name, boolean healthy, @NotNull HealthCheckType type, boolean critical) {
        this.name = Objects.requireNonNull(name);
        this.healthy = healthy;
        this.type = Objects.requireNonNull(type);
        this.critical = critical;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isHealthy() {
        return this.healthy;
    }

    public void setHealthy(boolean healthy) {
        this.healthy = healthy;
    }

    public HealthCheckType getType() {
        return this.type;
    }

    public void setType(HealthCheckType type) {
        this.type = type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public void setCritical(boolean critical) {
        this.critical = critical;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HealthStateView)) {
            return false;
        }
        HealthStateView that = (HealthStateView)o;
        return this.healthy == that.healthy && this.critical == that.critical && Objects.equals(this.name, that.name) && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.healthy, this.type, this.critical});
    }

    public String toString() {
        return "HealthStateView{name='" + this.name + "', healthy=" + this.healthy + ", type=" + this.type + ", critical=" + this.critical + "}";
    }

    @Override
    public int compareTo(HealthStateView other) {
        return this.name.compareTo(other.getName());
    }
}

