/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3.jersey;

import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.sql.SQLException;
import org.jdbi.v3.core.JdbiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingJdbiExceptionMapper
extends LoggingExceptionMapper<JdbiException> {
    public LoggingJdbiExceptionMapper() {
        this(LoggerFactory.getLogger(LoggingJdbiExceptionMapper.class));
    }

    LoggingJdbiExceptionMapper(Logger logger2) {
        super(logger2);
    }

    @Override
    protected void logException(long id, JdbiException exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof SQLException) {
            for (Throwable throwable : (SQLException)cause) {
                this.logger.error(this.formatLogMessage(id, throwable), throwable);
            }
        } else {
            this.logger.error(this.formatLogMessage(id, exception), exception);
        }
    }
}

