/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jdbi3.jersey;

import io.dropwizard.jersey.errors.LoggingExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class LoggingSQLExceptionMapper
extends LoggingExceptionMapper<SQLException> {
    LoggingSQLExceptionMapper(Logger logger2) {
        super(logger2);
    }

    public LoggingSQLExceptionMapper() {
        this(LoggerFactory.getLogger(LoggingSQLExceptionMapper.class));
    }

    @Override
    protected void logException(long id, SQLException exception) {
        String message = this.formatLogMessage(id, exception);
        for (Throwable throwable : exception) {
            this.logger.error(message, throwable);
        }
    }
}

