/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.util.Locale;

class NetUtil {
    static final int DEFAULT_TCP_BACKLOG_WINDOWS = 200;
    static final int DEFAULT_TCP_BACKLOG_LINUX = 128;
    static final String TCP_BACKLOG_SETTING_LOCATION = "/proc/sys/net/core/somaxconn";

    NetUtil() {
    }

    public static int getTcpBacklog() {
        return NetUtil.getTcpBacklog(NetUtil.getDefaultTcpBacklog());
    }

    static int getTcpBacklog(int tcpBacklog) {
        return AccessController.doPrivileged(() -> {
            Integer n;
            File file = new File(TCP_BACKLOG_SETTING_LOCATION);
            BufferedReader in = new BufferedReader(new FileReader(file));
            try {
                n = Integer.parseInt(in.readLine().trim());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException | NullPointerException | NumberFormatException | SecurityException e) {
                    return tcpBacklog;
                }
            }
            in.close();
            return n;
        });
    }

    private static boolean isWindows() {
        return System.getProperty("os.name", "").toLowerCase(Locale.US).contains("win");
    }

    private static int getDefaultTcpBacklog() {
        return NetUtil.isWindows() ? 200 : 128;
    }
}

