/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.request.logging;

import ch.qos.logback.access.jetty.RequestLogImpl;
import ch.qos.logback.access.spi.AccessEvent;
import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.spi.FilterReply;
import io.dropwizard.request.logging.DropwizardJettyServerAdapter;
import java.util.EventListener;
import java.util.Iterator;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.component.LifeCycle;

public class LogbackAccessRequestLog
extends RequestLogImpl {
    @Override
    public void configure() {
        this.setName("LogbackAccessRequestLog");
    }

    @Override
    public void log(Request jettyRequest, Response jettyResponse) {
        DropwizardJettyServerAdapter adapter = new DropwizardJettyServerAdapter(jettyRequest, jettyResponse);
        AccessEvent accessEvent = new AccessEvent(this, jettyRequest, jettyResponse, adapter);
        if (this.getFilterChainDecision(accessEvent) == FilterReply.DENY) {
            return;
        }
        this.appendLoopOnAppenders(accessEvent);
    }

    private void appendLoopOnAppenders(IAccessEvent iAccessEvent) {
        Iterator<Appender<IAccessEvent>> appenderIterator = this.iteratorForAppenders();
        while (appenderIterator.hasNext()) {
            appenderIterator.next().doAppend(iAccessEvent);
        }
    }

    @Override
    public boolean addEventListener(EventListener eventListener) {
        if (eventListener instanceof LifeCycle.Listener) {
            this.addLifeCycleListener((LifeCycle.Listener)eventListener);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeEventListener(EventListener eventListener) {
        if (eventListener instanceof LifeCycle.Listener) {
            this.removeLifeCycleListener((LifeCycle.Listener)eventListener);
            return true;
        }
        return false;
    }
}

