/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.servlets.assets;

import com.google.errorprone.annotations.Immutable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Immutable
public final class ByteRange {
    private final int start;
    private final int end;

    public ByteRange(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public static ByteRange parse(String byteRange, int resourceLength) {
        String asciiString = new String(byteRange.getBytes(), StandardCharsets.US_ASCII);
        if (!byteRange.contains("-")) {
            int start = Integer.parseInt(asciiString);
            return new ByteRange(start, resourceLength - 1);
        }
        if (byteRange.indexOf("-") == 0) {
            int start = Integer.parseInt(asciiString);
            return new ByteRange(resourceLength + start, resourceLength - 1);
        }
        List parts = Arrays.stream(asciiString.split("-", -1)).map(String::trim).filter(s2 -> !s2.isEmpty()).collect(Collectors.toList());
        int start = Integer.parseInt((String)parts.get(0));
        if (parts.size() == 2) {
            int end = Integer.parseInt((String)parts.get(1));
            if (end > resourceLength) {
                end = resourceLength - 1;
            }
            return new ByteRange(start, end);
        }
        return new ByteRange(start, resourceLength - 1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ByteRange other = (ByteRange)obj;
        return Objects.equals(this.start, other.start) && Objects.equals(this.end, other.end);
    }

    public int hashCode() {
        return Objects.hash(this.start, this.end);
    }

    public String toString() {
        return String.format("%d-%d", this.start, this.end);
    }
}

