/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import com.github.jaiimageio.jpeg2000.impl.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class QuantStepSizeSpec
extends ModuleSpec {
    private String defaultValue = "0.0078125";

    public QuantStepSizeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public QuantStepSizeSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        String param;
        if (values == null) {
            this.setDefault(new Float(this.defaultValue));
        }
        if ((param = (this.specified = values)) == null) {
            param = this.defaultValue;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block11: while (stk.hasMoreTokens()) {
            int i;
            Float value;
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = QuantStepSizeSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block11;
                    }
                    curSpecType = 2;
                    continue block11;
                }
                case 'c': {
                    compSpec = QuantStepSizeSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        continue block11;
                    }
                    curSpecType = 1;
                    continue block11;
                }
            }
            try {
                value = new Float(word);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad parameter for -Qstep option : " + word);
            }
            if (value.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("Normalized base step must be positive : " + value);
            }
            if (curSpecType == 0) {
                this.setDefault(value);
            } else if (curSpecType == 2) {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    if (!tileSpec[i]) continue;
                    this.setTileDef(i, value);
                }
            } else if (curSpecType == 1) {
                for (i = compSpec.length - 1; i >= 0; --i) {
                    if (!compSpec[i]) continue;
                    this.setCompDef(i, value);
                }
            } else {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    for (int j = compSpec.length - 1; j >= 0; --j) {
                        if (!tileSpec[i] || !compSpec[j]) continue;
                        this.setTileCompVal(i, j, value);
                    }
                }
            }
            curSpecType = 0;
            tileSpec = null;
            compSpec = null;
        }
        if (this.getDefault() == null) {
            int t2;
            int ndefspec = 0;
            for (t2 = nt - 1; t2 >= 0; --t2) {
                for (int c = nc - 1; c >= 0; --c) {
                    if (this.specValType[t2][c] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                this.setDefault(new Float(this.defaultValue));
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (int c = nc - 1; c >= 0; --c) {
                            if (this.specValType[0][c] != 2) continue;
                            this.specValType[0][c] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t2 = nt - 1; t2 >= 0; --t2) {
                            if (this.specValType[t2][0] != 1) continue;
                            this.specValType[t2][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }
}

