/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import com.github.jaiimageio.jpeg2000.impl.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.analysis.AnWTFilterIntLift5x3;

public class AnWTFilterSpec
extends ModuleSpec {
    private static final String REV_FILTER_STR = "w5x3";
    private static final String NON_REV_FILTER_STR = "w9x7";

    public AnWTFilterSpec(int nt, int nc, byte type, QuantTypeSpec qts, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        int c;
        String param = this.specified = values;
        boolean isFilterSpecified = true;
        if (values == null) {
            isFilterSpecified = false;
            if (wp.getLossless()) {
                this.setDefault(this.parseFilters(REV_FILTER_STR));
                return;
            }
            for (int t2 = nt - 1; t2 >= 0; --t2) {
                block17: for (int c2 = nc - 1; c2 >= 0; --c2) {
                    switch (qts.getSpecValType(t2, c2)) {
                        case 0: {
                            if (this.getDefault() == null) {
                                if (wp.getLossless()) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                }
                                if (((String)qts.getDefault()).equals("reversible")) {
                                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t2][c2] = 0;
                            continue block17;
                        }
                        case 1: {
                            if (!this.isCompSpecified(c2)) {
                                if (((String)qts.getCompDef(c2)).equals("reversible")) {
                                    this.setCompDef(c2, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setCompDef(c2, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t2][c2] = 1;
                            continue block17;
                        }
                        case 2: {
                            if (!this.isTileSpecified(t2)) {
                                if (((String)qts.getTileDef(t2)).equals("reversible")) {
                                    this.setTileDef(t2, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileDef(t2, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t2][c2] = 2;
                            continue block17;
                        }
                        case 3: {
                            if (!this.isTileCompSpecified(t2, c2)) {
                                if (((String)qts.getTileCompVal(t2, c2)).equals("reversible")) {
                                    this.setTileCompVal(t2, c2, this.parseFilters(REV_FILTER_STR));
                                } else {
                                    this.setTileCompVal(t2, c2, this.parseFilters(NON_REV_FILTER_STR));
                                }
                            }
                            this.specValType[t2][c2] = 3;
                            continue block17;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported specification type");
                        }
                    }
                }
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block18: while (stk.hasMoreTokens()) {
            String word = stk.nextToken();
            switch (word.charAt(0)) {
                case 'T': 
                case 't': {
                    tileSpec = AnWTFilterSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block18;
                    }
                    curSpecType = 2;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    compSpec = AnWTFilterSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        continue block18;
                    }
                    curSpecType = 1;
                    continue block18;
                }
                case 'W': 
                case 'w': {
                    int i;
                    if (wp.getLossless() && word.equalsIgnoreCase(NON_REV_FILTER_STR)) {
                        throw new IllegalArgumentException("Cannot use non reversible wavelet transform with '-lossless' option");
                    }
                    AnWTFilter[][] filter = this.parseFilters(word);
                    if (curSpecType == 0) {
                        this.setDefault(filter);
                    } else if (curSpecType == 2) {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            if (!tileSpec[i]) continue;
                            this.setTileDef(i, filter);
                        }
                    } else if (curSpecType == 1) {
                        for (i = compSpec.length - 1; i >= 0; --i) {
                            if (!compSpec[i]) continue;
                            this.setCompDef(i, filter);
                        }
                    } else {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            for (int j = compSpec.length - 1; j >= 0; --j) {
                                if (!tileSpec[i] || !compSpec[j]) continue;
                                this.setTileCompVal(i, j, filter);
                            }
                        }
                    }
                    curSpecType = 0;
                    tileSpec = null;
                    compSpec = null;
                    continue block18;
                }
            }
            throw new IllegalArgumentException("Bad construction for parameter: " + word);
        }
        if (this.getDefault() == null) {
            int t3;
            int ndefspec = 0;
            for (t3 = nt - 1; t3 >= 0; --t3) {
                for (int c3 = nc - 1; c3 >= 0; --c3) {
                    if (this.specValType[t3][c3] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                if (((String)qts.getDefault()).equals("reversible")) {
                    this.setDefault(this.parseFilters(REV_FILTER_STR));
                } else {
                    this.setDefault(this.parseFilters(NON_REV_FILTER_STR));
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (c = nc - 1; c >= 0; --c) {
                            if (this.specValType[0][c] != 2) continue;
                            this.specValType[0][c] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t3 = nt - 1; t3 >= 0; --t3) {
                            if (this.specValType[t3][0] != 1) continue;
                            this.specValType[t3][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
        for (int t4 = nt - 1; t4 >= 0; --t4) {
            for (c = nc - 1; c >= 0; --c) {
                if (((String)qts.getTileCompVal(t4, c)).equals("reversible")) {
                    if (this.isReversible(t4, c)) continue;
                    if (!isFilterSpecified) {
                        this.setTileCompVal(t4, c, this.parseFilters(REV_FILTER_STR));
                        continue;
                    }
                    throw new IllegalArgumentException("Filter of tile-component (" + t4 + "," + c + ") does not allow reversible quantization. Specify '-Qtype expounded' or '-Qtype derived'in the command line.");
                }
                if (!this.isReversible(t4, c)) continue;
                if (!isFilterSpecified) {
                    this.setTileCompVal(t4, c, this.parseFilters(NON_REV_FILTER_STR));
                    continue;
                }
                throw new IllegalArgumentException("Filter of tile-component (" + t4 + "," + c + ") does not allow non-reversible quantization. Specify '-Qtype reversible' in the command line");
            }
        }
    }

    private AnWTFilter[][] parseFilters(String word) {
        AnWTFilter[][] filt = new AnWTFilter[2][1];
        if (word.equalsIgnoreCase(REV_FILTER_STR)) {
            filt[0][0] = new AnWTFilterIntLift5x3();
            filt[1][0] = new AnWTFilterIntLift5x3();
            return filt;
        }
        if (word.equalsIgnoreCase(NON_REV_FILTER_STR)) {
            filt[0][0] = new AnWTFilterFloatLift9x7();
            filt[1][0] = new AnWTFilterFloatLift9x7();
            return filt;
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I filter: " + word);
    }

    public int getWTDataType(int t2, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t2, c);
        return an[0][0].getDataType();
    }

    public AnWTFilter[] getHFilters(int t2, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t2, c);
        return an[0];
    }

    public AnWTFilter[] getVFilters(int t2, int c) {
        AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t2, c);
        return an[1];
    }

    public String toString() {
        String str = "";
        str = str + "nTiles=" + this.nTiles + "\nnComp=" + this.nComp + "\n\n";
        for (int t2 = 0; t2 < this.nTiles; ++t2) {
            for (int c = 0; c < this.nComp; ++c) {
                int i;
                AnWTFilter[][] an = (AnWTFilter[][])this.getSpec(t2, c);
                str = str + "(t:" + t2 + ",c:" + c + ")\n";
                str = str + "\tH:";
                for (i = 0; i < an[0].length; ++i) {
                    str = str + " " + an[0][i];
                }
                str = str + "\n\tV:";
                for (i = 0; i < an[1].length; ++i) {
                    str = str + " " + an[1][i];
                }
                str = str + "\n";
            }
        }
        return str;
    }

    public boolean isReversible(int t2, int c) {
        AnWTFilter[] hfilter = this.getHFilters(t2, c);
        AnWTFilter[] vfilter = this.getVFilters(t2, c);
        for (int i = hfilter.length - 1; i >= 0; --i) {
            if (hfilter[i].isReversible() && vfilter[i].isReversible()) continue;
            return false;
        }
        return true;
    }
}

