/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.argparse4j.impl.choice;

import net.sourceforge.argparse4j.helper.TextHelper;
import net.sourceforge.argparse4j.inf.ArgumentChoice;

public class RangeArgumentChoice<T extends Comparable<T>>
implements ArgumentChoice {
    private final T min_;
    private final T max_;

    public RangeArgumentChoice(T min2, T max) {
        this.min_ = min2;
        this.max_ = max;
    }

    @Override
    public boolean contains(Object val2) {
        if (this.min_.getClass().equals(val2.getClass())) {
            Comparable v = (Comparable)val2;
            return this.min_.compareTo((Comparable)v) <= 0 && 0 <= this.max_.compareTo((Comparable)v);
        }
        throw new IllegalArgumentException(String.format(TextHelper.LOCALE_ROOT, "type mismatch (Make sure that you specified correct Argument.type()): expected: %s actual: %s", this.min_.getClass().getName(), val2.getClass().getName()));
    }

    @Override
    public String textualFormat() {
        return String.format(TextHelper.LOCALE_ROOT, "{%s..%s}", this.min_, this.max_);
    }

    public String toString() {
        return this.textualFormat();
    }
}

