/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;

public class COSFloat
extends COSNumber {
    private final float value;
    private String valueAsString;

    public COSFloat(float aFloat) {
        this.value = aFloat;
    }

    public COSFloat(String aFloat) throws IOException {
        float parsedValue;
        String stringValue = null;
        try {
            float f = Float.parseFloat(aFloat);
            parsedValue = this.coerce(f);
            stringValue = f == parsedValue ? aFloat : null;
        }
        catch (NumberFormatException e) {
            if (aFloat.startsWith("--")) {
                aFloat = aFloat.substring(1);
            } else if (aFloat.matches("^0\\.0*-\\d+")) {
                aFloat = "-" + aFloat.replaceFirst("-", "");
            } else {
                throw new IOException("Error expected floating point number actual='" + aFloat + "'", e);
            }
            try {
                parsedValue = this.coerce(Float.parseFloat(aFloat));
            }
            catch (NumberFormatException e2) {
                throw new IOException("Error expected floating point number actual='" + aFloat + "'", e2);
            }
        }
        this.value = parsedValue;
        this.valueAsString = stringValue;
    }

    private float coerce(float floatValue) {
        if (floatValue == Float.POSITIVE_INFINITY) {
            return Float.MAX_VALUE;
        }
        if (floatValue == Float.NEGATIVE_INFINITY) {
            return -3.4028235E38f;
        }
        if (Math.abs(floatValue) < Float.MIN_NORMAL) {
            return 0.0f;
        }
        return floatValue;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value) == Float.floatToIntBits(this.value);
    }

    public int hashCode() {
        return Float.hashCode(this.value);
    }

    public String toString() {
        return "COSFloat{" + this.formatString() + "}";
    }

    private String formatString() {
        if (this.valueAsString == null) {
            String s2 = String.valueOf(this.value);
            boolean simpleFormat = s2.indexOf(69) < 0;
            this.valueAsString = simpleFormat ? s2 : new BigDecimal(s2).stripTrailingZeros().toPlainString();
        }
        return this.valueAsString;
    }

    @Override
    public void accept(ICOSVisitor visitor) throws IOException {
        visitor.visitFromFloat(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(this.formatString().getBytes(StandardCharsets.ISO_8859_1));
    }
}

