/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.multipdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;

public class PDFCloneUtility {
    private static final Log LOG = LogFactory.getLog(PDFCloneUtility.class);
    private final PDDocument destination;
    private final Map<COSBase, COSBase> clonedVersion = new HashMap<COSBase, COSBase>();
    private final Set<COSBase> clonedValues = new HashSet<COSBase>();

    PDFCloneUtility(PDDocument dest) {
        this.destination = dest;
    }

    PDDocument getDestination() {
        return this.destination;
    }

    public <TCOSBase extends COSBase> TCOSBase cloneForNewDocument(TCOSBase base) throws IOException {
        if (base == null) {
            return null;
        }
        COSBase retval = this.clonedVersion.get(base);
        if (retval != null) {
            return (TCOSBase)retval;
        }
        if (this.clonedValues.contains(base)) {
            return base;
        }
        retval = this.cloneCOSBaseForNewDocument(base);
        this.clonedVersion.put(base, retval);
        this.clonedValues.add(retval);
        return (TCOSBase)retval;
    }

    COSBase cloneCOSBaseForNewDocument(COSBase base) throws IOException {
        if (base instanceof COSObject) {
            return this.cloneForNewDocument(((COSObject)base).getObject());
        }
        if (base instanceof COSArray) {
            return this.cloneCOSArray((COSArray)base);
        }
        if (base instanceof COSStream) {
            return this.cloneCOSStream((COSStream)base);
        }
        if (base instanceof COSDictionary) {
            return this.cloneCOSDictionary((COSDictionary)base);
        }
        return base;
    }

    private COSArray cloneCOSArray(COSArray array) throws IOException {
        COSArray newArray = new COSArray();
        for (int i = 0; i < array.size(); ++i) {
            COSBase value = array.get(i);
            if (this.hasSelfReference(array, value)) {
                newArray.add(newArray);
                continue;
            }
            newArray.add(this.cloneForNewDocument(value));
        }
        return newArray;
    }

    private COSStream cloneCOSStream(COSStream stream) throws IOException {
        COSStream newStream = this.destination.getDocument().createCOSStream();
        try (OutputStream output = newStream.createRawOutputStream();
             InputStream input = stream.createRawInputStream();){
            IOUtils.copy(input, output);
        }
        this.clonedVersion.put(stream, newStream);
        for (Map.Entry<COSName, COSBase> entry : stream.entrySet()) {
            COSBase value = entry.getValue();
            if (this.hasSelfReference(stream, value)) {
                newStream.setItem(entry.getKey(), (COSBase)newStream);
                continue;
            }
            newStream.setItem(entry.getKey(), this.cloneForNewDocument(value));
        }
        return newStream;
    }

    private COSDictionary cloneCOSDictionary(COSDictionary dictionary) throws IOException {
        COSDictionary newDictionary = new COSDictionary();
        this.clonedVersion.put(dictionary, newDictionary);
        for (Map.Entry<COSName, COSBase> entry : dictionary.entrySet()) {
            COSBase value = entry.getValue();
            if (this.hasSelfReference(dictionary, value)) {
                newDictionary.setItem(entry.getKey(), (COSBase)newDictionary);
                continue;
            }
            newDictionary.setItem(entry.getKey(), this.cloneForNewDocument(value));
        }
        return newDictionary;
    }

    void cloneMerge(COSObjectable base, COSObjectable target) throws IOException {
        if (base == null || base == target) {
            return;
        }
        this.cloneMergeCOSBase(base.getCOSObject(), target.getCOSObject());
    }

    private void cloneMergeCOSBase(COSBase source, COSBase target) throws IOException {
        block4: {
            COSBase targetBase;
            COSBase sourceBase;
            block3: {
                sourceBase = source instanceof COSObject ? ((COSObject)source).getObject() : source;
                COSBase cOSBase = targetBase = target instanceof COSObject ? ((COSObject)target).getObject() : target;
                if (!(sourceBase instanceof COSArray) || !(targetBase instanceof COSArray)) break block3;
                COSArray array = (COSArray)sourceBase;
                for (int i = 0; i < array.size(); ++i) {
                    ((COSArray)targetBase).add(this.cloneForNewDocument(array.get(i)));
                }
                break block4;
            }
            if (!(sourceBase instanceof COSDictionary) || !(targetBase instanceof COSDictionary)) break block4;
            COSDictionary sourceDict = (COSDictionary)sourceBase;
            COSDictionary targetDict = (COSDictionary)targetBase;
            for (Map.Entry<COSName, COSBase> entry : sourceDict.entrySet()) {
                COSName key = entry.getKey();
                COSBase value = entry.getValue();
                if (targetDict.getItem(key) != null) {
                    this.cloneMerge(value, targetDict.getItem(key));
                    continue;
                }
                targetDict.setItem(key, this.cloneForNewDocument(value));
            }
        }
    }

    private boolean hasSelfReference(COSBase parent, COSBase value) {
        COSBase actual;
        if (value instanceof COSObject && (actual = ((COSObject)value).getObject()) == parent) {
            COSObject cosObj = (COSObject)value;
            LOG.warn(parent.getClass().getSimpleName() + " object has a reference to itself: " + cosObj.getObjectNumber() + " " + cosObj.getGenerationNumber() + " R");
            return true;
        }
        return false;
    }
}

