/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.annotation;

import java.io.IOException;
import java.util.Calendar;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationPopup;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDExternalDataDictionary;

public class PDAnnotationMarkup
extends PDAnnotation {
    public static final String RT_REPLY = "R";
    public static final String RT_GROUP = "Group";

    public PDAnnotationMarkup() {
    }

    public PDAnnotationMarkup(COSDictionary dict) {
        super(dict);
    }

    public String getTitlePopup() {
        return this.getCOSObject().getString(COSName.T);
    }

    public void setTitlePopup(String t2) {
        this.getCOSObject().setString(COSName.T, t2);
    }

    public PDAnnotationPopup getPopup() {
        COSDictionary popup = this.getCOSObject().getCOSDictionary(COSName.POPUP);
        return popup != null ? new PDAnnotationPopup(popup) : null;
    }

    public void setPopup(PDAnnotationPopup popup) {
        this.getCOSObject().setItem(COSName.POPUP, (COSObjectable)popup);
    }

    public float getConstantOpacity() {
        return this.getCOSObject().getFloat(COSName.CA, 1.0f);
    }

    public void setConstantOpacity(float ca) {
        this.getCOSObject().setFloat(COSName.CA, ca);
    }

    public String getRichContents() {
        COSBase base = this.getCOSObject().getDictionaryObject(COSName.RC);
        if (base instanceof COSString) {
            return ((COSString)base).getString();
        }
        if (base instanceof COSStream) {
            return ((COSStream)base).toTextString();
        }
        return null;
    }

    public void setRichContents(String rc) {
        this.getCOSObject().setItem(COSName.RC, (COSBase)new COSString(rc));
    }

    public Calendar getCreationDate() {
        return this.getCOSObject().getDate(COSName.CREATION_DATE);
    }

    public void setCreationDate(Calendar creationDate) {
        this.getCOSObject().setDate(COSName.CREATION_DATE, creationDate);
    }

    public PDAnnotation getInReplyTo() throws IOException {
        COSDictionary base = this.getCOSObject().getCOSDictionary(COSName.IRT);
        return base != null ? PDAnnotation.createAnnotation(base) : null;
    }

    public void setInReplyTo(PDAnnotation irt) {
        this.getCOSObject().setItem(COSName.IRT, (COSObjectable)irt);
    }

    public String getSubject() {
        return this.getCOSObject().getString(COSName.SUBJ);
    }

    public void setSubject(String subj) {
        this.getCOSObject().setString(COSName.SUBJ, subj);
    }

    public String getReplyType() {
        return this.getCOSObject().getNameAsString(COSName.RT, RT_REPLY);
    }

    public void setReplyType(String rt) {
        this.getCOSObject().setName(COSName.RT, rt);
    }

    public String getIntent() {
        return this.getCOSObject().getNameAsString(COSName.IT);
    }

    public void setIntent(String it) {
        this.getCOSObject().setName(COSName.IT, it);
    }

    public PDExternalDataDictionary getExternalData() {
        COSDictionary exData = this.getCOSObject().getCOSDictionary(COSName.EX_DATA);
        return exData != null ? new PDExternalDataDictionary(exData) : null;
    }

    public void setExternalData(PDExternalDataDictionary externalData) {
        this.getCOSObject().setItem(COSName.EX_DATA, (COSObjectable)externalData);
    }

    public void setBorderStyle(PDBorderStyleDictionary bs) {
        this.getCOSObject().setItem(COSName.BS, (COSObjectable)bs);
    }

    public PDBorderStyleDictionary getBorderStyle() {
        COSDictionary bs = this.getCOSObject().getCOSDictionary(COSName.BS);
        return bs != null ? new PDBorderStyleDictionary(bs) : null;
    }
}

