/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.imageio;

import java.awt.image.BufferedImage;
import javax.imageio.ImageWriteParam;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.tools.imageio.MetaUtil;
import org.w3c.dom.NodeList;

final class TIFFUtil {
    private static final Log LOG = LogFactory.getLog(TIFFUtil.class);

    private TIFFUtil() {
    }

    public static void setCompressionType(ImageWriteParam param, BufferedImage image) {
        if (image.getType() == 12 && image.getColorModel().getPixelSize() == 1) {
            param.setCompressionType("CCITT T.6");
        } else {
            param.setCompressionType("LZW");
        }
    }

    static void updateMetadata(IIOMetadata metadata, BufferedImage image, int dpi) throws IIOInvalidTreeException {
        IIOMetadataNode ifd;
        String metaDataFormat = metadata.getNativeMetadataFormatName();
        if (metaDataFormat == null) {
            LOG.debug("TIFF image writer doesn't support any data format");
            return;
        }
        MetaUtil.debugLogMetadata(metadata, metaDataFormat);
        IIOMetadataNode root = new IIOMetadataNode(metaDataFormat);
        NodeList nodeListTIFFIFD = root.getElementsByTagName("TIFFIFD");
        if (nodeListTIFFIFD.getLength() == 0) {
            ifd = new IIOMetadataNode("TIFFIFD");
            root.appendChild(ifd);
        } else {
            ifd = (IIOMetadataNode)nodeListTIFFIFD.item(0);
        }
        ifd.appendChild(TIFFUtil.createRationalField(282, "XResolution", dpi, 1));
        ifd.appendChild(TIFFUtil.createRationalField(283, "YResolution", dpi, 1));
        ifd.appendChild(TIFFUtil.createShortField(296, "ResolutionUnit", 2));
        ifd.appendChild(TIFFUtil.createLongField(278, "RowsPerStrip", image.getHeight()));
        ifd.appendChild(TIFFUtil.createAsciiField(305, "Software", "PDFBOX"));
        if (image.getType() == 12 && image.getColorModel().getPixelSize() == 1) {
            ifd.appendChild(TIFFUtil.createShortField(262, "PhotometricInterpretation", 0));
        }
        metadata.mergeTree(metaDataFormat, root);
        MetaUtil.debugLogMetadata(metadata, metaDataFormat);
    }

    private static IIOMetadataNode createShortField(int tiffTagNumber, String name, int val2) {
        IIOMetadataNode field = new IIOMetadataNode("TIFFField");
        field.setAttribute("number", Integer.toString(tiffTagNumber));
        field.setAttribute("name", name);
        IIOMetadataNode arrayNode = new IIOMetadataNode("TIFFShorts");
        field.appendChild(arrayNode);
        IIOMetadataNode valueNode = new IIOMetadataNode("TIFFShort");
        arrayNode.appendChild(valueNode);
        valueNode.setAttribute("value", Integer.toString(val2));
        return field;
    }

    private static IIOMetadataNode createAsciiField(int number, String name, String val2) {
        IIOMetadataNode field = new IIOMetadataNode("TIFFField");
        field.setAttribute("number", Integer.toString(number));
        field.setAttribute("name", name);
        IIOMetadataNode arrayNode = new IIOMetadataNode("TIFFAsciis");
        field.appendChild(arrayNode);
        IIOMetadataNode valueNode = new IIOMetadataNode("TIFFAscii");
        arrayNode.appendChild(valueNode);
        valueNode.setAttribute("value", val2);
        return field;
    }

    private static IIOMetadataNode createLongField(int number, String name, long val2) {
        IIOMetadataNode field = new IIOMetadataNode("TIFFField");
        field.setAttribute("number", Integer.toString(number));
        field.setAttribute("name", name);
        IIOMetadataNode arrayNode = new IIOMetadataNode("TIFFLongs");
        field.appendChild(arrayNode);
        IIOMetadataNode valueNode = new IIOMetadataNode("TIFFLong");
        arrayNode.appendChild(valueNode);
        valueNode.setAttribute("value", Long.toString(val2));
        return field;
    }

    private static IIOMetadataNode createRationalField(int number, String name, int numerator, int denominator) {
        IIOMetadataNode field = new IIOMetadataNode("TIFFField");
        field.setAttribute("number", Integer.toString(number));
        field.setAttribute("name", name);
        IIOMetadataNode arrayNode = new IIOMetadataNode("TIFFRationals");
        field.appendChild(arrayNode);
        IIOMetadataNode valueNode = new IIOMetadataNode("TIFFRational");
        arrayNode.appendChild(valueNode);
        valueNode.setAttribute("value", numerator + "/" + denominator);
        return field;
    }
}

