/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.internal;

import org.jdbi.v3.core.inlined.org.antlr.v4.runtime.;
import org.jdbi.v3.core.inlined.org.antlr.v4.runtime.$Token;
import org.jdbi.v3.core.internal.lexer.SqlScriptLexer;
import org.jdbi.v3.core.statement.internal.ErrorListener;

public class SqlScriptParser {
    private final TokenHandler semicolonHandler;

    public SqlScriptParser(TokenHandler semicolonHandler) {
        this.semicolonHandler = semicolonHandler;
    }

    public String parse(.CharStream charStream) {
        StringBuilder sb = new StringBuilder();
        SqlScriptLexer lexer = new SqlScriptLexer(charStream);
        lexer.addErrorListener(new ErrorListener());
        boolean endOfFile = false;
        int blockLevel = 0;
        block8: while (!endOfFile) {
            $Token t2 = lexer.nextToken();
            switch (t2.getType()) {
                case -1: {
                    endOfFile = true;
                    continue block8;
                }
                case 7: {
                    if (blockLevel == 0) {
                        this.semicolonHandler.handle(t2, sb);
                        continue block8;
                    }
                    sb.append(t2.getText());
                    continue block8;
                }
                case 5: 
                case 6: {
                    blockLevel += 5 == t2.getType() ? 1 : -1;
                    sb.append(t2.getText());
                    continue block8;
                }
                case 1: 
                case 2: {
                    continue block8;
                }
                case 3: {
                    if (sb.length() <= 0) continue block8;
                    sb.append('\n');
                    continue block8;
                }
                case 4: 
                case 8: 
                case 9: {
                    sb.append(t2.getText());
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unrecognizable token " + t2);
        }
        return sb.toString();
    }

    public static interface TokenHandler {
        public void handle($Token var1, StringBuilder var2);
    }
}

