/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.result.internal;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.MappingException;
import org.jdbi.v3.core.mapper.NoSuchMapperException;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.StatementContext;

public class RowViewImpl
extends RowView {
    private final StatementContext ctx;
    private final ResultSet rs;
    private final Map<Type, RowMapper<?>> rowMappers = new ConcurrentHashMap();
    private final Map<QualifiedType<?>, ColumnMapper<?>> columnMappers = new ConcurrentHashMap();

    public RowViewImpl(ResultSet rs, StatementContext ctx) {
        this.rs = rs;
        this.ctx = ctx;
    }

    @Override
    public Object getRow(Type type) {
        try {
            return this.rowMapperFor(type).map(this.rs, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    private RowMapper<?> rowMapperFor(Type type) throws SQLException {
        if (this.rowMappers.containsKey(type)) {
            return this.rowMappers.get(type);
        }
        RowMapper<?> mapper = this.ctx.findRowMapperFor(type).orElseThrow(() -> new NoSuchMapperException("No row mapper registered for " + type)).specialize(this.rs, this.ctx);
        this.rowMappers.put(type, mapper);
        return mapper;
    }

    @Override
    public <T> T getColumn(int column, QualifiedType<T> type) {
        try {
            return (T)this.columnMapperFor(type).map(this.rs, column, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public <T> T getColumn(String column, QualifiedType<T> type) {
        try {
            return (T)this.columnMapperFor(type).map(this.rs, column, this.ctx);
        }
        catch (SQLException e) {
            throw new MappingException(e);
        }
    }

    private ColumnMapper<?> columnMapperFor(QualifiedType<?> type) {
        return this.columnMappers.computeIfAbsent(type, t2 -> this.ctx.findColumnMapperFor(t2).orElseThrow(() -> new NoSuchMapperException("No column mapper registered for " + t2)));
    }
}

