/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.sql.SQLException;
import java.time.Instant;
import org.jdbi.v3.core.internal.UtilityClassException;
import org.jdbi.v3.core.statement.SqlLoggable;
import org.jdbi.v3.core.statement.SqlLogger;
import org.jdbi.v3.core.statement.StatementContext;

class SqlLoggerUtil {
    private SqlLoggerUtil() {
        throw new UtilityClassException();
    }

    static <T> T wrap(SqlLoggable<T> r, StatementContext ctx, SqlLogger logger2) throws SQLException {
        try {
            ctx.setExecutionMoment(Instant.now());
            logger2.logBeforeExecution(ctx);
            T result = r.invoke();
            ctx.setCompletionMoment(Instant.now());
            logger2.logAfterExecution(ctx);
            return result;
        }
        catch (SQLException e) {
            ctx.setExceptionMoment(Instant.now());
            logger2.logException(ctx, e);
            throw e;
        }
    }
}

