/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava;

import java.lang.reflect.Type;
import java.util.Optional;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.generic.GenericTypes;
import org.jdbi.v3.core.internal.UtilityClassException;

public class GuavaArguments {
    private GuavaArguments() {
        throw new UtilityClassException();
    }

    public static ArgumentFactory factory() {
        return new Factory();
    }

    private static class Factory
    implements ArgumentFactory {
        private Factory() {
        }

        @Override
        public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
            if (value instanceof com.google.common.base.Optional) {
                Object nestedValue = ((com.google.common.base.Optional)value).orNull();
                Type nestedType = this.findOptionalType(expectedType, nestedValue);
                return config.get(Arguments.class).findFor(nestedType, nestedValue);
            }
            return Optional.empty();
        }

        private Type findOptionalType(Type wrapperType, Object nestedValue) {
            Optional<Type> nestedType;
            if (GenericTypes.getErasedType(wrapperType).equals(com.google.common.base.Optional.class) && (nestedType = GenericTypes.findGenericParameter(wrapperType, com.google.common.base.Optional.class)).isPresent()) {
                return nestedType.get();
            }
            return nestedValue == null ? Object.class : nestedValue.getClass();
        }
    }
}

