/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.guava.codec;

import com.google.common.reflect.TypeToken;
import com.google.errorprone.annotations.ThreadSafe;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jdbi.v3.core.codec.Codec;
import org.jdbi.v3.core.codec.CodecFactory;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.meta.Beta;

@ThreadSafe
@Beta
public class TypeResolvingCodecFactory
extends CodecFactory {
    public static CodecFactory.Builder builder() {
        return new CodecFactory.Builder(TypeResolvingCodecFactory::new);
    }

    public static CodecFactory forSingleCodec(QualifiedType<?> type, Codec<?> codec) {
        return new TypeResolvingCodecFactory(Collections.singletonMap(type, codec));
    }

    public TypeResolvingCodecFactory(Map<QualifiedType<?>, Codec<?>> codecMap) {
        super(codecMap);
    }

    @Override
    protected Codec<?> resolveType(QualifiedType<?> qualifiedType) {
        return this.codecMap.computeIfAbsent(qualifiedType, q -> {
            TypeToken candidate;
            QualifiedType<?> type;
            Codec codec = null;
            TypeToken.TypeSet candidates = TypeToken.of(q.getType()).getTypes();
            Iterator iterator = candidates.iterator();
            while (iterator.hasNext() && (codec = (Codec)this.codecMap.get(type = QualifiedType.of((candidate = (TypeToken)iterator.next()).getType()))) == null) {
            }
            return codec;
        });
    }
}

