/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerDecorator;
import org.jdbi.v3.sqlobject.SqlMethodAnnotatedHandlerDecorator;

public class HandlerDecorators
implements JdbiConfig<HandlerDecorators> {
    private final List<HandlerDecorator> decorators = new CopyOnWriteArrayList<HandlerDecorator>();

    public HandlerDecorators() {
        this.register(new SqlMethodAnnotatedHandlerDecorator());
    }

    private HandlerDecorators(HandlerDecorators that) {
        this.decorators.addAll(that.decorators);
    }

    public HandlerDecorators register(HandlerDecorator decorator) {
        this.decorators.add(decorator);
        return this;
    }

    public Handler applyDecorators(Handler base, Class<?> sqlObjectType, Method method) {
        Handler handler = base;
        for (HandlerDecorator decorator : this.decorators) {
            handler = decorator.decorateHandler(handler, sqlObjectType, method);
        }
        return handler;
    }

    @Override
    public HandlerDecorators createCopy() {
        return new HandlerDecorators(this);
    }
}

