/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.internal.exceptions.Sneaky;
import org.jdbi.v3.sqlobject.Handler;
import org.jdbi.v3.sqlobject.HandlerFactory;
import org.jdbi.v3.sqlobject.SqlOperation;

class SqlMethodHandlerFactory
implements HandlerFactory {
    SqlMethodHandlerFactory() {
    }

    @Override
    public Optional<Handler> buildHandler(Class<?> sqlObjectType, Method method) {
        List sqlMethodAnnotations = Stream.of(method.getAnnotations()).map(Annotation::annotationType).filter(type -> type.isAnnotationPresent(SqlOperation.class)).collect(Collectors.toList());
        if (sqlMethodAnnotations.isEmpty()) {
            return Optional.empty();
        }
        if (sqlMethodAnnotations.size() > 1) {
            throw new IllegalStateException(String.format("Mutually exclusive annotations on method %s.%s: %s", sqlObjectType.getName(), method.getName(), sqlMethodAnnotations));
        }
        if (method.isDefault() && !method.isSynthetic()) {
            throw new IllegalStateException(String.format("Default method %s.%s has @%s annotation. SQL object methods may be default, or have a SQL method annotation, but not both.", sqlObjectType.getSimpleName(), method.getName(), ((Class)sqlMethodAnnotations.get(0)).getSimpleName()));
        }
        return Optional.of(sqlMethodAnnotations.stream().map(type -> type.getAnnotation(SqlOperation.class)).map(a -> this.buildHandler(a.value(), sqlObjectType, method)).findFirst().orElseThrow(() -> new IllegalStateException(String.format("Method %s.%s must be default or be annotated with a SQL method annotation.", sqlObjectType.getSimpleName(), method.getName()))));
    }

    private Handler buildHandler(Class<? extends Handler> handlerType, Class<?> sqlObjectType, Method method) {
        try {
            return handlerType.getConstructor(Class.class, Method.class).newInstance(sqlObjectType, method);
        }
        catch (InvocationTargetException e) {
            throw Sneaky.throwAnyway(e.getCause());
        }
        catch (ReflectiveOperationException e) {
            try {
                return handlerType.getConstructor(Method.class).newInstance(method);
            }
            catch (InvocationTargetException e2) {
                throw Sneaky.throwAnyway(e2.getCause());
            }
            catch (ReflectiveOperationException e2) {
                try {
                    return handlerType.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (InvocationTargetException e3) {
                    throw Sneaky.throwAnyway(e3.getCause());
                }
                catch (ReflectiveOperationException e4) {
                    throw new IllegalStateException("Handler class " + handlerType + " cannot be instantiated. Expected a constructor with parameters (Class, Method), (Method), or ().", e4);
                }
            }
        }
    }
}

