/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.sqlobject.customizer.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Optional;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.mapper.Mappers;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifiers;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.SqlStatementCustomizerFactory;
import org.jdbi.v3.sqlobject.customizer.SqlStatementParameterCustomizer;
import org.jdbi.v3.sqlobject.internal.ParameterUtil;

public class BindFactory
implements SqlStatementCustomizerFactory {
    @Override
    public SqlStatementParameterCustomizer createForParameter(Annotation annotation, Class<?> sqlObjectType, Method method, final Parameter param, final int index, final Type type) {
        Bind b = (Bind)annotation;
        String nameFromAnnotation = b == null ? "" : b.value();
        final Optional<String> name = ParameterUtil.findParameterName(nameFromAnnotation, param);
        return new SqlStatementParameterCustomizer(){

            @Override
            public void apply(SqlStatement<?> stmt, Object arg) throws SQLException {
                QualifiedType<?> qualifiedType = this.qualifiedType(stmt.getConfig());
                stmt.bindByType(index, arg, qualifiedType);
                name.ifPresent(n -> stmt.bindByType((String)n, arg, qualifiedType));
            }

            @Override
            public void warm(ConfigRegistry config) {
                config.get(Mappers.class).findFor(this.qualifiedType(config));
            }

            private QualifiedType<?> qualifiedType(ConfigRegistry config) {
                return QualifiedType.of(type).withAnnotations(config.get(Qualifiers.class).findFor(param));
            }
        };
    }
}

